/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.datatables;

import io.springlets.data.web.datatables.Datatables;
import io.springlets.data.web.datatables.DatatablesColumns;
import java.util.Map;
import java.util.Set;
import org.springframework.core.MethodParameter;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;

public class DatatablesColumnsHandlerMethodArgumentResolver
implements HandlerMethodArgumentResolver {
    private static final int MAX_COLUMNS = 50;
    private final int maxColumns;

    public DatatablesColumnsHandlerMethodArgumentResolver() {
        this(50);
    }

    public DatatablesColumnsHandlerMethodArgumentResolver(int maxColumns) {
        this.maxColumns = maxColumns;
    }

    public boolean supportsParameter(MethodParameter parameter) {
        return DatatablesColumns.class.equals((Object)parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest request, WebDataBinderFactory binderFactory) throws Exception {
        DatatablesColumns columns = new ColumnsParametersParser(this.maxColumns, request.getParameterMap()).getColumns();
        return columns;
    }

    static class ColumnsParametersParser {
        private int maxColumns;
        private Map<String, String[]> parameters;

        public ColumnsParametersParser(int maxColumns, Map<String, String[]> parameterMap) {
            this.maxColumns = maxColumns;
            this.parameters = parameterMap;
        }

        public DatatablesColumns getColumns() {
            DatatablesColumns columns = new DatatablesColumns();
            Set<Map.Entry<String, String[]>> entrySet = this.parameters.entrySet();
            for (Map.Entry<String, String[]> entry : entrySet) {
                String parameter = entry.getKey();
                String value = this.getParameter(parameter);
                if (StringUtils.isEmpty((Object)value) || !Datatables.isColumn(parameter)) continue;
                this.addColumnValue(columns, parameter, value);
            }
            return columns;
        }

        private void addColumnValue(DatatablesColumns columns, String parameter, String value) {
            Datatables.ColumnParamType type = Datatables.columnParameterType(parameter);
            int index = Datatables.columnIndex(parameter);
            if (type != null && this.isValidIndex(index)) {
                switch (type) {
                    case DATA: {
                        columns.setData(index, value);
                        break;
                    }
                    case NAME: {
                        columns.setName(index, value);
                        break;
                    }
                    case ORDERABLE: {
                        columns.setOrderable(index, Boolean.valueOf(value));
                        break;
                    }
                    case REGEX: {
                        columns.setSearchRegexp(index, Boolean.valueOf(value));
                        break;
                    }
                    case SEARCH: {
                        columns.setSearch(index, value);
                        break;
                    }
                    case SEARCHABLE: {
                        columns.setSearchable(index, Boolean.valueOf(value));
                        break;
                    }
                }
            }
        }

        private boolean isValidIndex(int index) {
            return index > -1 && index < this.maxColumns;
        }

        private String getParameter(String name) {
            String[] values = this.parameters.get(name);
            return values == null || values.length == 0 ? null : values[0];
        }
    }
}

