/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.select2;

import io.springlets.data.web.select2.Select2DataSupport;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;

public class Select2DataByMethods<T>
extends Select2DataSupport<T> {
    private final ConversionService conversionService;
    private boolean includeEntireElement;
    private IdProvider<T> idProvider;
    private CaptionProvider<T> captionProvider;

    public Select2DataByMethods(Page<T> page, IdProvider<T> idProvider, CaptionProvider<T> captionProvider, ConversionService conversionService) {
        super(page);
        Assert.notNull(page, (String)"A ConversionService is required");
        this.conversionService = conversionService;
        this.idProvider = idProvider;
        this.captionProvider = captionProvider;
        this.includeEntireElement = false;
    }

    public Select2DataByMethods(Page<T> page, IdProvider<T> idProvider, CaptionProvider<T> captionProvider, ConversionService conversionService, boolean includeEntireElement) {
        this(page, idProvider, captionProvider, conversionService);
        this.includeEntireElement = includeEntireElement;
    }

    @Override
    protected Select2DataSupport.Data<T> createData(T element) {
        String id = this.getIdAsString(element);
        String text = this.getAsString(element);
        if (this.includeEntireElement) {
            return new Select2DataSupport.Data<T>(id, text, element);
        }
        return new Select2DataSupport.Data(id, text);
    }

    @Override
    protected String getAsString(T element) {
        return (String)this.conversionService.convert(this.captionProvider.getCaption(element), String.class);
    }

    @Override
    protected String getIdAsString(T element) {
        return (String)this.conversionService.convert(this.idProvider.getId(element), String.class);
    }

    public static interface CaptionProvider<T> {
        public Object getCaption(T var1);
    }

    public static interface IdProvider<T> {
        public Object getId(T var1);
    }
}

