/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.select2;

import java.util.ArrayList;
import java.util.List;
import org.springframework.data.domain.Page;
import org.springframework.util.Assert;

public abstract class Select2DataSupport<T> {
    private final Page<T> page;

    public Select2DataSupport(Page<T> page) {
        this.page = page;
        Assert.notNull(page, (String)"The results list is required");
    }

    public List<Data<T>> getResults() {
        List content = this.page.getContent();
        ArrayList<Data<T>> results = new ArrayList<Data<T>>(content.size());
        for (int i = 0; i < content.size(); ++i) {
            Data data = this.createData(content.get(i));
            results.add(data);
        }
        return results;
    }

    public Pagination getPagination() {
        return new Pagination(!this.page.isLast());
    }

    protected Data<T> createData(T element) {
        String id = this.getIdAsString(element);
        String text = this.getAsString(element);
        return new Data(id, text);
    }

    protected abstract String getAsString(T var1);

    protected abstract String getIdAsString(T var1);

    protected static class Pagination {
        private final boolean more;

        public Pagination(boolean more) {
            this.more = more;
        }

        public boolean isMore() {
            return this.more;
        }
    }

    protected static class Data<T> {
        private final String id;
        private final String text;
        private final T info;

        public Data(String id, String text) {
            this.id = id;
            this.text = text;
            this.info = null;
        }

        public Data(String id, String text, T element) {
            this.id = id;
            this.text = text;
            this.info = element;
        }

        public String getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }

        public T getInfo() {
            return this.info;
        }
    }
}

