/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.select2;

import io.springlets.data.web.select2.Select2DataSupport;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.domain.Page;
import org.springframework.expression.Expression;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public class Select2DataWithConversion<T>
extends Select2DataSupport<T> {
    private final ConversionService conversionService;
    private final Expression parseIdExpression;
    private boolean includeEntireElement;

    public Select2DataWithConversion(Page<T> page, String idExpression, ConversionService conversionService) {
        super(page);
        Assert.notNull(page, (String)"A ConversionService is required");
        this.conversionService = conversionService;
        TemplateParserContext templateParserContext = new TemplateParserContext();
        SpelExpressionParser parser = new SpelExpressionParser();
        this.parseIdExpression = parser.parseExpression(idExpression, (ParserContext)templateParserContext);
        this.includeEntireElement = false;
    }

    public Select2DataWithConversion(Page<T> page, String idExpression, ConversionService conversionService, boolean includeEntireElement) {
        this(page, idExpression, conversionService);
        this.includeEntireElement = includeEntireElement;
    }

    @Override
    protected Select2DataSupport.Data<T> createData(T element) {
        String id = this.getIdAsString(element);
        String text = this.getAsString(element);
        if (this.includeEntireElement) {
            return new Select2DataSupport.Data<T>(id, text, element);
        }
        return new Select2DataSupport.Data(id, text);
    }

    @Override
    protected String getAsString(T element) {
        return (String)this.conversionService.convert(element, String.class);
    }

    @Override
    protected String getIdAsString(T element) {
        return (String)this.parseIdExpression.getValue(element, String.class);
    }
}

