/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.web.validation;

import io.springlets.data.web.validation.MessageI18n;
import io.springlets.data.web.validation.ValidatorService;
import java.util.List;
import java.util.Map;
import org.springframework.util.Assert;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class GenericValidator<T>
implements Validator {
    private Class<?> clazz;
    private ValidatorService validatorService;

    public GenericValidator(Class<?> clazz, T validatorService) {
        Assert.notNull(clazz, (String)"ERROR: You must provide a valid Class type");
        Assert.notNull(validatorService, (String)"ERROR: You must provide a valid Validator service.");
        this.clazz = clazz;
        this.validatorService = (ValidatorService)validatorService;
    }

    public boolean supports(Class<?> clazz) {
        return clazz.equals(this.clazz);
    }

    public void validate(Object obj, Errors errors) {
        Map<String, List<MessageI18n>> messages = this.validatorService.validate(obj);
        for (Map.Entry<String, List<MessageI18n>> element : messages.entrySet()) {
            for (MessageI18n message : element.getValue()) {
                errors.rejectValue(element.getKey(), message.label, message.values, "");
            }
        }
    }
}

