/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.jpa.domain;

import io.springlets.data.jpa.domain.EmbeddableImageException;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URLConnection;
import javax.imageio.ImageIO;
import javax.persistence.Embeddable;
import org.apache.commons.codec.binary.Base64;
import org.springframework.util.Assert;

@Embeddable
public class EmbeddableImage {
    private static final String DATA_IMAGE_PREFIX = "data:image/";
    private static final String BASE64_TYPE = ";base64,";
    private byte[] image;

    public EmbeddableImage() {
    }

    public EmbeddableImage(byte[] image) {
        this.image = image;
    }

    public byte[] getImage() {
        return this.image;
    }

    public void setImage(byte[] image) {
        this.image = image;
    }

    public String getFormat() {
        Assert.notNull((Object)this.image, (String)"ERROR: The provided image should have a valid image byte array.");
        try {
            String format = URLConnection.guessContentTypeFromStream(new ByteArrayInputStream(this.image));
            if (format != null) {
                return format.replace("image/", "");
            }
        }
        catch (IOException e) {
            throw new EmbeddableImageException("Error identify image format", e);
        }
        return null;
    }

    public String getBase64() {
        Assert.notNull((Object)this.image, (String)"ERROR: The provided image should have a valid image byte array.");
        return Base64.encodeBase64String((byte[])this.image);
    }

    public EmbeddableImage resize(int width, int height) {
        try {
            BufferedImage imageBuffer = this.getBufferedImage();
            int type = imageBuffer.getType() == 0 ? 2 : imageBuffer.getType();
            BufferedImage resizedImage = new BufferedImage(width, height, type);
            Graphics2D g = resizedImage.createGraphics();
            g.drawImage(imageBuffer, 0, 0, width, height, null);
            g.dispose();
            return this.writeImage(resizedImage, this.getFormat());
        }
        catch (IOException e) {
            throw new EmbeddableImageException("Error resizing image", e);
        }
    }

    public EmbeddableImage format(String newFormat) {
        try {
            return this.writeImage(this.getBufferedImage(), newFormat);
        }
        catch (IOException e) {
            throw new EmbeddableImageException("Error formating image to " + newFormat, e);
        }
    }

    public EmbeddableImage formatAndResize(String newFormat, int width, int height) {
        EmbeddableImage formattedImage = this.format(newFormat);
        return formattedImage.resize(width, height);
    }

    private BufferedImage getBufferedImage() throws IOException {
        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(this.image);
        BufferedImage imageBuffer = ImageIO.read(imageInputStream);
        if (imageBuffer == null) {
            throw new EmbeddableImageException("ERROR: The provided ." + this.getFormat() + " image is not valid.");
        }
        return imageBuffer;
    }

    private EmbeddableImage writeImage(BufferedImage image, String format) throws IOException {
        ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, format, byteArrayOut);
        return new EmbeddableImage(byteArrayOut.toByteArray());
    }

    public String toString() {
        return DATA_IMAGE_PREFIX.concat(this.getFormat()).concat(BASE64_TYPE).concat(this.getBase64());
    }
}

