/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.jpa.repository.support;

import io.springlets.data.jpa.repository.DetachableJpaRepository;
import java.io.Serializable;
import javax.persistence.EntityManager;
import org.springframework.data.jpa.repository.support.JpaEntityInformation;
import org.springframework.data.jpa.repository.support.SimpleJpaRepository;

public class DetachableJpaRepositoryImpl<T, ID extends Serializable>
extends SimpleJpaRepository<T, ID>
implements DetachableJpaRepository<T, ID> {
    private final EntityManager entityManager;

    public DetachableJpaRepositoryImpl(JpaEntityInformation<T, ?> entityInformation, EntityManager entityManager) {
        super(entityInformation, entityManager);
        this.entityManager = entityManager;
    }

    public DetachableJpaRepositoryImpl(Class<T> domainClass, EntityManager em) {
        super(domainClass, em);
        this.entityManager = em;
    }

    @Override
    public T findOneDetached(ID id) {
        Object entity = this.findOne((Serializable)id);
        if (entity != null) {
            this.entityManager.detach(entity);
        }
        return (T)entity;
    }
}

