/*
 * Decompiled with CFR 0.152.
 */
package io.springlets.data.jpa.repository.support;

import com.querydsl.core.BooleanBuilder;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.Order;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.NumberExpression;
import com.querydsl.core.types.dsl.PathBuilder;
import com.querydsl.core.types.dsl.StringPath;
import com.querydsl.jpa.JPQLQuery;
import io.springlets.data.domain.GlobalSearch;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import javax.persistence.metamodel.SingularAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.support.QueryDslRepositorySupport;
import org.springframework.util.StringUtils;

public class QueryDslRepositorySupportExt<T>
extends QueryDslRepositorySupport {
    private static final Logger LOG = LoggerFactory.getLogger(QueryDslRepositorySupportExt.class);
    private final Class<T> domainClass;
    private PathBuilder<Object> entityIdPath = null;

    public QueryDslRepositorySupportExt(Class<T> domainClass) {
        super(domainClass);
        this.domainClass = domainClass;
    }

    protected JPQLQuery<T> applyPagination(Pageable pageable, JPQLQuery<T> query) {
        return this.getQuerydsl().applyPagination(pageable, query);
    }

    protected JPQLQuery<T> applyPagination(Pageable pageable, JPQLQuery<T> query, AttributeMappingBuilder mapping) {
        return this.applyPagination(pageable, query, mapping.asMap());
    }

    protected JPQLQuery<T> applyPagination(Pageable pageable, JPQLQuery<T> query, Map<String, Path<?>[]> attributeMapping) {
        if (pageable == null) {
            return query;
        }
        Sort sort = pageable.getSort();
        if (sort != null) {
            ArrayList<Sort.Order> mappedOrders = new ArrayList<Sort.Order>();
            for (Sort.Order order : sort) {
                Path<?>[] paths;
                if (!attributeMapping.containsKey(order.getProperty())) {
                    LOG.warn("The property (%1) is not included in the attributeMapping, will order using the property as it is", (Object)order.getProperty());
                    mappedOrders.add(order);
                    continue;
                }
                for (Path<?> path : paths = attributeMapping.get(order.getProperty())) {
                    Sort.Order mappedOrder = new Sort.Order(order.getDirection(), QueryDslRepositorySupportExt.preparePropertyPath(path));
                    mappedOrders.add(mappedOrder);
                }
            }
            if (mappedOrders.isEmpty()) {
                return query;
            }
            PageRequest mappedPageable = new PageRequest(pageable.getPageNumber(), pageable.getPageSize(), new Sort(mappedOrders));
            return this.applyPagination((Pageable)mappedPageable, query);
        }
        return this.applyPagination(pageable, query);
    }

    protected AttributeMappingBuilder buildMapper() {
        return new AttributeMappingBuilder();
    }

    protected JPQLQuery<T> applyOrderById(JPQLQuery<T> query) {
        PathBuilder<Object> idPath = this.getEntityId();
        return (JPQLQuery)query.orderBy(new OrderSpecifier[]{new OrderSpecifier(Order.ASC, idPath, OrderSpecifier.NullHandling.NullsFirst)});
    }

    protected PathBuilder<Object> getEntityId() {
        if (this.entityIdPath == null) {
            EntityType<T> entity = this.getEntityMetaModel();
            SingularAttribute id = entity.getId(entity.getIdType().getJavaType());
            this.entityIdPath = this.getBuilder().get(id.getName());
        }
        return this.entityIdPath;
    }

    private EntityType<T> getEntityMetaModel() {
        Metamodel metamodel = this.getEntityManager().getMetamodel();
        EntityType entity = metamodel.entity(this.domainClass);
        return entity;
    }

    protected JPQLQuery<T> applyGlobalSearch(String text, JPQLQuery<T> query, Path<?> ... globalSearchAttributes) {
        if (text != null && !StringUtils.isEmpty((Object)text) && globalSearchAttributes.length > 0) {
            BooleanBuilder searchCondition = new BooleanBuilder();
            for (int i = 0; i < globalSearchAttributes.length; ++i) {
                Path<?> path = globalSearchAttributes[i];
                if (path instanceof StringPath) {
                    StringPath stringPath = (StringPath)path;
                    searchCondition.or((Predicate)stringPath.containsIgnoreCase(text));
                    continue;
                }
                if (!(path instanceof NumberExpression)) continue;
                searchCondition.or((Predicate)((NumberExpression)path).like("%".concat(text).concat("%")));
            }
            return (JPQLQuery)query.where(new Predicate[]{searchCondition});
        }
        return query;
    }

    protected JPQLQuery<T> applyGlobalSearch(GlobalSearch globalSearch, JPQLQuery<T> query, Path<?> ... globalSearchAttributes) {
        if (globalSearch != null) {
            String txt = globalSearch.getText();
            return this.applyGlobalSearch(txt, query, globalSearchAttributes);
        }
        return query;
    }

    protected <M> Page<M> loadPage(JPQLQuery<T> query, Pageable pageable, Expression<M> expression) {
        long totalFound = query.fetchCount();
        List results = query.select(expression).fetch();
        return new PageImpl(results, pageable, totalFound);
    }

    private static String preparePropertyPath(Path<?> path) {
        Path root = path.getRoot();
        return root == null || path.equals((Object)root) ? path.toString() : path.toString().substring(root.toString().length() + 1);
    }

    public static class AttributeMappingBuilder {
        private final Map<String, Path<?>[]> attrMapping = new HashMap<String, Path<?>[]>();

        public AttributeMappingBuilder map(String attribute, Path<?> ... realAttributes) {
            this.attrMapping.put(attribute, realAttributes);
            return this;
        }

        public Map<String, Path<?>[]> asMap() {
            return Collections.unmodifiableMap(this.attrMapping);
        }
    }
}

