/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.client.naming.utils;

import com.alibaba.nacos.client.utils.LogUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

public class IoUtils {
    public static String toString(InputStream input, String encoding) {
        try {
            return null == encoding ? IoUtils.toString(new InputStreamReader(input, "UTF-8")) : IoUtils.toString(new InputStreamReader(input, encoding));
        }
        catch (Exception e) {
            LogUtils.NAMING_LOGGER.error("NA", (Object)"read input failed.", (Object)e);
            return "";
        }
    }

    public static String toString(Reader reader) throws IOException {
        CharArrayWriter sw = new CharArrayWriter();
        IoUtils.copy(reader, sw);
        return sw.toString();
    }

    public static long copy(Reader input, Writer output) throws IOException {
        char[] buffer = new char[4096];
        long count = 0L;
        int n = 0;
        while ((n = input.read(buffer)) >= 0) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static long copy(InputStream input, OutputStream output) throws IOException {
        int bytesRead;
        byte[] buffer = new byte[1024];
        int totalBytes = 0;
        while ((bytesRead = input.read(buffer)) != -1) {
            output.write(buffer, 0, bytesRead);
            totalBytes += bytesRead;
        }
        return totalBytes;
    }

    public static List<String> readLines(Reader input) throws IOException {
        BufferedReader reader = IoUtils.toBufferedReader(input);
        ArrayList<String> list = new ArrayList<String>();
        String line = null;
        while (null != (line = reader.readLine())) {
            list.add(line);
        }
        return list;
    }

    private static BufferedReader toBufferedReader(Reader reader) {
        return reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String source, String target) throws IOException {
        File sf = new File(source);
        if (!sf.exists()) {
            throw new IllegalArgumentException("source file does not exist.");
        }
        File tf = new File(target);
        if (!tf.getParentFile().mkdirs()) {
            throw new RuntimeException("failed to create parent directory.");
        }
        if (!tf.exists() && !tf.createNewFile()) {
            throw new RuntimeException("failed to create target file.");
        }
        AbstractInterruptibleChannel sc = null;
        FileChannel tc = null;
        try {
            tc = new FileOutputStream(tf).getChannel();
            sc = new FileInputStream(sf).getChannel();
            ((FileChannel)sc).transferTo(0L, ((FileChannel)sc).size(), tc);
        }
        finally {
            if (null != sc) {
                sc.close();
            }
            if (null != tc) {
                tc.close();
            }
        }
    }

    public static void delete(File fileOrDir) throws IOException {
        if (fileOrDir == null) {
            return;
        }
        if (fileOrDir.isDirectory()) {
            IoUtils.cleanDirectory(fileOrDir);
        }
        if (fileOrDir.delete()) {
            throw new RuntimeException("failed to delete file: " + fileOrDir.getAbsolutePath());
        }
    }

    public static void cleanDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            String message = directory + " does not exist";
            throw new IllegalArgumentException(message);
        }
        if (!directory.isDirectory()) {
            String message = directory + " is not a directory";
            throw new IllegalArgumentException(message);
        }
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of " + directory);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                IoUtils.delete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
    }

    public static boolean isGzipStream(byte[] bytes) {
        int minByteArraySize = 2;
        if (bytes == null || bytes.length < minByteArraySize) {
            return false;
        }
        return 35615 == ((bytes[1] << 8 | bytes[0]) & 0xFFFF);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] tryDecompress(byte[] raw) throws Exception {
        if (!IoUtils.isGzipStream(raw)) {
            return raw;
        }
        GZIPInputStream gis = null;
        ByteArrayOutputStream out = null;
        try {
            gis = new GZIPInputStream(new ByteArrayInputStream(raw));
            out = new ByteArrayOutputStream();
            IoUtils.copy(gis, out);
            byte[] byArray = out.toByteArray();
            return byArray;
        }
        finally {
            if (out != null) {
                out.close();
            }
            if (gis != null) {
                gis.close();
            }
        }
    }
}

