/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.config.server.controller.ConfigServletInner;
import com.alibaba.nacos.config.server.exception.NacosException;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo4Beta;
import com.alibaba.nacos.config.server.model.GroupkeyListenserStatus;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.RestResult;
import com.alibaba.nacos.config.server.model.SameConfigPolicy;
import com.alibaba.nacos.config.server.model.SampleResult;
import com.alibaba.nacos.config.server.result.ResultBuilder;
import com.alibaba.nacos.config.server.result.code.ResultCodeEnum;
import com.alibaba.nacos.config.server.service.AggrWhitelist;
import com.alibaba.nacos.config.server.service.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.service.ConfigSubService;
import com.alibaba.nacos.config.server.service.PersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.MD5Util;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.RequestUtil;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.config.server.utils.ZipUtils;
import com.alibaba.nacos.config.server.utils.event.EventDispatcher;
import com.alibaba.nacos.core.utils.SystemUtils;
import java.io.IOException;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/v1/cs/configs"})
public class ConfigController {
    private static final Logger log = LoggerFactory.getLogger(ConfigController.class);
    private static final String NAMESPACE_PUBLIC_KEY = "public";
    public static final String EXPORT_CONFIG_FILE_NAME = "nacos_config_export_";
    public static final String EXPORT_CONFIG_FILE_NAME_EXT = ".zip";
    public static final String EXPORT_CONFIG_FILE_NAME_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private final transient ConfigServletInner inner;
    private final transient PersistService persistService;
    private final transient ConfigSubService configSubService;

    @Autowired
    public ConfigController(ConfigServletInner configServletInner, PersistService persistService, ConfigSubService configSubService) {
        this.inner = configServletInner;
        this.persistService = persistService;
        this.configSubService = configSubService;
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public Boolean publishConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="content") String content, @RequestParam(value="tag", required=false) String tag, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="desc", required=false) String desc, @RequestParam(value="use", required=false) String use, @RequestParam(value="effect", required=false) String effect, @RequestParam(value="type", required=false) String type, @RequestParam(value="schema", required=false) String schema) throws NacosException {
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        ParamUtils.checkParam(dataId, group, "datumId", content);
        ParamUtils.checkParam(tag);
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(10);
        if (configTags != null) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        if (desc != null) {
            configAdvanceInfo.put("desc", desc);
        }
        if (use != null) {
            configAdvanceInfo.put("use", use);
        }
        if (effect != null) {
            configAdvanceInfo.put("effect", effect);
        }
        if (type != null) {
            configAdvanceInfo.put("type", type);
        }
        if (schema != null) {
            configAdvanceInfo.put("schema", schema);
        }
        ParamUtils.checkParam(configAdvanceInfo);
        if (AggrWhitelist.isAggrDataId(dataId)) {
            log.warn("[aggr-conflict] {} attemp to publish single data, {}, {}", new Object[]{RequestUtil.getRemoteIp(request), dataId, group});
            throw new NacosException(403, "dataId:" + dataId + " is aggr");
        }
        Timestamp time = TimeUtils.getCurrentTime();
        String betaIps = request.getHeader("betaIps");
        ConfigInfo configInfo = new ConfigInfo(dataId, group, tenant, appName, content);
        if (StringUtils.isBlank((CharSequence)betaIps)) {
            if (StringUtils.isBlank((CharSequence)tag)) {
                this.persistService.insertOrUpdate(srcIp, srcUser, configInfo, time, configAdvanceInfo, false);
                EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, dataId, group, tenant, time.getTime()));
            } else {
                this.persistService.insertOrUpdateTag(configInfo, tag, srcIp, srcUser, time, false);
                EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, dataId, group, tenant, tag, time.getTime()));
            }
        } else {
            this.persistService.insertOrUpdateBeta(configInfo, betaIps, srcIp, srcUser, time, false);
            EventDispatcher.fireEvent(new ConfigDataChangeEvent(true, dataId, group, tenant, time.getTime()));
        }
        ConfigTraceService.logPersistenceEvent(dataId, group, tenant, requestIpApp, time.getTime(), SystemUtils.LOCAL_IP, "pub", content);
        return true;
    }

    @RequestMapping(method={RequestMethod.GET})
    public void getConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) throws IOException, ServletException, NacosException {
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        ParamUtils.checkParam(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        this.inner.doGetConfig(request, response, dataId, group, tenant, tag, clientIp);
    }

    @RequestMapping(params={"show=all"}, method={RequestMethod.GET})
    @ResponseBody
    public ConfigAllInfo detailConfigInfo(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) throws NacosException {
        ParamUtils.checkParam(dataId, group, "datumId", "content");
        return this.persistService.findConfigAllInfo(dataId, group, tenant);
    }

    @RequestMapping(method={RequestMethod.DELETE})
    @ResponseBody
    public Boolean deleteConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="tag", required=false) String tag) throws NacosException {
        ParamUtils.checkParam(dataId, group, "datumId", "rm");
        ParamUtils.checkParam(tag);
        String clientIp = RequestUtil.getRemoteIp(request);
        if (StringUtils.isBlank((CharSequence)tag)) {
            this.persistService.removeConfigInfo(dataId, group, tenant, clientIp, null);
        } else {
            this.persistService.removeConfigInfoTag(dataId, group, tenant, tag, clientIp, null);
        }
        Timestamp time = TimeUtils.getCurrentTime();
        ConfigTraceService.logPersistenceEvent(dataId, group, tenant, null, time.getTime(), clientIp, "remove", null);
        EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, dataId, group, tenant, tag, time.getTime()));
        return true;
    }

    @RequestMapping(params={"delType=ids"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult<Boolean> deleteConfigs(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="ids") List<Long> ids) {
        String clientIp = RequestUtil.getRemoteIp(request);
        Timestamp time = TimeUtils.getCurrentTime();
        List<ConfigInfo> configInfoList = this.persistService.removeConfigInfoByIds(ids, clientIp, null);
        if (!CollectionUtils.isEmpty(configInfoList)) {
            for (ConfigInfo configInfo : configInfoList) {
                ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), null, time.getTime(), clientIp, "remove", null);
                EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            }
        }
        return ResultBuilder.buildSuccessResult(true);
    }

    @RequestMapping(value={"/catalog"}, method={RequestMethod.GET})
    @ResponseBody
    public RestResult<ConfigAdvanceInfo> getConfigAdvanceInfo(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        RestResult<ConfigAdvanceInfo> rr = new RestResult<ConfigAdvanceInfo>();
        ConfigAdvanceInfo configInfo = this.persistService.findConfigAdvanceInfo(dataId, group, tenant);
        rr.setCode(200);
        rr.setData(configInfo);
        return rr;
    }

    @RequestMapping(value={"/listener"}, method={RequestMethod.POST})
    public void listener(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Map<String, String> clientMd5Map;
        request.setAttribute("org.apache.catalina.ASYNC_SUPPORTED", (Object)true);
        String probeModify = request.getParameter("Listening-Configs");
        if (StringUtils.isBlank((CharSequence)probeModify)) {
            throw new IllegalArgumentException("invalid probeModify");
        }
        probeModify = URLDecoder.decode(probeModify, "UTF-8");
        try {
            clientMd5Map = MD5Util.getClientMd5Map(probeModify);
        }
        catch (Throwable e) {
            throw new IllegalArgumentException("invalid probeModify");
        }
        this.inner.doPollingConfig(request, response, clientMd5Map, probeModify.length());
    }

    @RequestMapping(value={"/listener"}, method={RequestMethod.GET})
    @ResponseBody
    public GroupkeyListenserStatus getListeners(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false) String tenant, @RequestParam(value="sampleTime", required=false, defaultValue="1") int sampleTime) throws Exception {
        group = StringUtils.isBlank((CharSequence)group) ? "DEFAULT_GROUP" : group;
        SampleResult collectSampleResult = this.configSubService.getCollectSampleResult(dataId, group, tenant, sampleTime);
        GroupkeyListenserStatus gls = new GroupkeyListenserStatus();
        gls.setCollectStatus(200);
        if (collectSampleResult.getLisentersGroupkeyStatus() != null) {
            gls.setLisentersGroupkeyStatus(collectSampleResult.getLisentersGroupkeyStatus());
        }
        return gls;
    }

    @RequestMapping(params={"search=accurate"}, method={RequestMethod.GET})
    @ResponseBody
    public Page<ConfigInfo> searchConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(100);
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        try {
            return this.persistService.findConfigInfo4Page(pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            log.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @RequestMapping(params={"search=blur"}, method={RequestMethod.GET})
    @ResponseBody
    public Page<ConfigInfo> fuzzySearchConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="config_tags", required=false) String configTags, @RequestParam(value="pageNo") int pageNo, @RequestParam(value="pageSize") int pageSize) {
        HashMap<String, Object> configAdvanceInfo = new HashMap<String, Object>(50);
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            configAdvanceInfo.put("appName", appName);
        }
        if (StringUtils.isNotBlank((CharSequence)configTags)) {
            configAdvanceInfo.put("config_tags", configTags);
        }
        try {
            return this.persistService.findConfigInfoLike4Page(pageNo, pageSize, dataId, group, tenant, configAdvanceInfo);
        }
        catch (Exception e) {
            String errorMsg = "serialize page error, dataId=" + dataId + ", group=" + group;
            log.error(errorMsg, (Throwable)e);
            throw new RuntimeException(errorMsg, e);
        }
    }

    @RequestMapping(params={"beta=true"}, method={RequestMethod.DELETE})
    @ResponseBody
    public RestResult<Boolean> stopBeta(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        RestResult<Boolean> rr = new RestResult<Boolean>();
        try {
            this.persistService.removeConfigInfo4Beta(dataId, group, tenant);
        }
        catch (Throwable e) {
            log.error("remove beta data error", e);
            rr.setCode(500);
            rr.setData(false);
            rr.setMessage("remove beta data error");
            return rr;
        }
        EventDispatcher.fireEvent(new ConfigDataChangeEvent(true, dataId, group, tenant, System.currentTimeMillis()));
        rr.setCode(200);
        rr.setData(true);
        rr.setMessage("stop beta ok");
        return rr;
    }

    @RequestMapping(params={"beta=true"}, method={RequestMethod.GET})
    @ResponseBody
    public RestResult<ConfigInfo4Beta> queryBeta(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId") String dataId, @RequestParam(value="group") String group, @RequestParam(value="tenant", required=false, defaultValue="") String tenant) {
        RestResult<ConfigInfo4Beta> rr = new RestResult<ConfigInfo4Beta>();
        try {
            ConfigInfo4Beta ci = this.persistService.findConfigInfo4Beta(dataId, group, tenant);
            rr.setCode(200);
            rr.setData(ci);
            rr.setMessage("stop beta ok");
            return rr;
        }
        catch (Throwable e) {
            log.error("remove beta data error", e);
            rr.setCode(500);
            rr.setMessage("remove beta data error");
            return rr;
        }
    }

    @RequestMapping(params={"export=true"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> exportConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="dataId", required=false) String dataId, @RequestParam(value="group", required=false) String group, @RequestParam(value="appName", required=false) String appName, @RequestParam(value="tenant", required=false, defaultValue="") String tenant, @RequestParam(value="ids", required=false) List<Long> ids) {
        ids.removeAll(Collections.singleton(null));
        List<ConfigInfo> dataList = this.persistService.findAllConfigInfo4Export(dataId, group, tenant, appName, ids);
        ArrayList<ZipUtils.ZipItem> zipItemList = new ArrayList<ZipUtils.ZipItem>();
        StringBuilder metaData = null;
        for (ConfigInfo ci : dataList) {
            if (StringUtils.isNotBlank((CharSequence)ci.getAppName())) {
                String metaDataId;
                if (metaData == null) {
                    metaData = new StringBuilder();
                }
                if ((metaDataId = ci.getDataId()).contains(".")) {
                    metaDataId = metaDataId.substring(0, metaDataId.lastIndexOf(".")) + "~" + metaDataId.substring(metaDataId.lastIndexOf(".") + 1);
                }
                metaData.append(ci.getGroup()).append(".").append(metaDataId).append(".app=").append(ci.getAppName()).append("\r\n");
            }
            String itemName = ci.getGroup() + "/" + ci.getDataId();
            zipItemList.add(new ZipUtils.ZipItem(itemName, ci.getContent()));
        }
        if (metaData != null) {
            zipItemList.add(new ZipUtils.ZipItem(".meta.yml", metaData.toString()));
        }
        HttpHeaders headers = new HttpHeaders();
        String fileName = EXPORT_CONFIG_FILE_NAME + DateFormatUtils.format((Date)new Date(), (String)EXPORT_CONFIG_FILE_NAME_DATE_FORMAT) + EXPORT_CONFIG_FILE_NAME_EXT;
        headers.add("Content-Disposition", "attachment;filename=" + fileName);
        return new ResponseEntity((Object)ZipUtils.zip(zipItemList), (MultiValueMap)headers, HttpStatus.OK);
    }

    @RequestMapping(params={"import=true"}, method={RequestMethod.POST})
    @ResponseBody
    public RestResult<Map<String, Object>> importAndPublishConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="namespace", required=false) String namespace, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy, MultipartFile file) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (StringUtils.isNotBlank((CharSequence)namespace) && this.persistService.tenantInfoCountByTenantId(namespace) <= 0) {
            failedData.put("succCount", 0);
            return ResultBuilder.buildResult(ResultCodeEnum.NAMESPACE_NOT_EXIST, failedData);
        }
        ArrayList<ConfigInfo> configInfoList = null;
        try {
            List<ZipUtils.ZipItem> itemList;
            ZipUtils.UnZipResult unziped = ZipUtils.unzip(file.getBytes());
            ZipUtils.ZipItem metaDataZipItem = unziped.getMetaDataItem();
            HashMap<String, String> metaDataMap = new HashMap<String, String>(16);
            if (metaDataZipItem != null) {
                String[] metaDataArr;
                String metaDataStr = metaDataZipItem.getItemData();
                for (String metaDataItem : metaDataArr = metaDataStr.split("\r\n")) {
                    String[] metaDataItemArr = metaDataItem.split("=");
                    if (metaDataItemArr.length != 2) {
                        failedData.put("succCount", 0);
                        return ResultBuilder.buildResult(ResultCodeEnum.METADATA_ILLEGAL, failedData);
                    }
                    metaDataMap.put(metaDataItemArr[0], metaDataItemArr[1]);
                }
            }
            if ((itemList = unziped.getZipItemList()) != null && !itemList.isEmpty()) {
                configInfoList = new ArrayList<ConfigInfo>(itemList.size());
                for (ZipUtils.ZipItem item : itemList) {
                    String[] groupAdnDataId = item.getItemName().split("/");
                    if (!item.getItemName().contains("/") || groupAdnDataId.length != 2) {
                        failedData.put("succCount", 0);
                        return ResultBuilder.buildResult(ResultCodeEnum.DATA_VALIDATION_FAILED, failedData);
                    }
                    String group = groupAdnDataId[0];
                    String dataId = groupAdnDataId[1];
                    String tempDataId = dataId;
                    if (tempDataId.contains(".")) {
                        tempDataId = tempDataId.substring(0, tempDataId.lastIndexOf(".")) + "~" + tempDataId.substring(tempDataId.lastIndexOf(".") + 1);
                    }
                    String metaDataId = group + "." + tempDataId + ".app";
                    ConfigInfo ci = new ConfigInfo();
                    ci.setTenant(namespace);
                    ci.setGroup(group);
                    ci.setDataId(dataId);
                    ci.setContent(item.getItemData());
                    if (metaDataMap.get(metaDataId) != null) {
                        ci.setAppName((String)metaDataMap.get(metaDataId));
                    }
                    configInfoList.add(ci);
                }
            }
        }
        catch (IOException e) {
            failedData.put("succCount", 0);
            log.error("parsing data failed", (Throwable)e);
            return ResultBuilder.buildResult(ResultCodeEnum.PARSING_DATA_FAILED, failedData);
        }
        if (configInfoList == null || configInfoList.isEmpty()) {
            failedData.put("succCount", 0);
            return ResultBuilder.buildResult(ResultCodeEnum.DATA_EMPTY, failedData);
        }
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        Timestamp time = TimeUtils.getCurrentTime();
        Map<String, Object> saveResult = this.persistService.batchInsertOrUpdate(configInfoList, srcUser, srcIp, null, time, false, policy);
        for (ConfigInfo configInfo : configInfoList) {
            EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), requestIpApp, time.getTime(), SystemUtils.LOCAL_IP, "pub", configInfo.getContent());
        }
        return ResultBuilder.buildSuccessResult("\u5bfc\u5165\u6210\u529f", saveResult);
    }

    @RequestMapping(params={"clone=true"}, method={RequestMethod.GET})
    @ResponseBody
    public RestResult<Map<String, Object>> cloneConfig(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="src_user", required=false) String srcUser, @RequestParam(value="tenant", required=true) String namespace, @RequestParam(value="ids", required=true) List<Long> ids, @RequestParam(value="policy", defaultValue="ABORT") SameConfigPolicy policy) throws NacosException {
        HashMap<String, Integer> failedData = new HashMap<String, Integer>(4);
        if (NAMESPACE_PUBLIC_KEY.equals(namespace.toLowerCase())) {
            namespace = "";
        } else if (this.persistService.tenantInfoCountByTenantId(namespace) <= 0) {
            failedData.put("succCount", 0);
            return ResultBuilder.buildResult(ResultCodeEnum.NAMESPACE_NOT_EXIST, failedData);
        }
        ids.removeAll(Collections.singleton(null));
        List<ConfigInfo> queryedDataList = this.persistService.findAllConfigInfo4Export(null, null, null, null, ids);
        if (queryedDataList == null || queryedDataList.isEmpty()) {
            failedData.put("succCount", 0);
            return ResultBuilder.buildResult(ResultCodeEnum.DATA_EMPTY, failedData);
        }
        ArrayList<ConfigInfo> configInfoList4Clone = new ArrayList<ConfigInfo>(queryedDataList.size());
        for (ConfigInfo ci : queryedDataList) {
            ConfigInfo ci4save = new ConfigInfo();
            ci4save.setTenant(namespace);
            ci4save.setGroup(ci.getGroup());
            ci4save.setDataId(ci.getDataId());
            ci4save.setContent(ci.getContent());
            if (StringUtils.isNotBlank((CharSequence)ci.getAppName())) {
                ci4save.setAppName(ci.getAppName());
            }
            configInfoList4Clone.add(ci4save);
        }
        if (configInfoList4Clone.isEmpty()) {
            failedData.put("succCount", 0);
            return ResultBuilder.buildResult(ResultCodeEnum.DATA_EMPTY, failedData);
        }
        String srcIp = RequestUtil.getRemoteIp(request);
        String requestIpApp = RequestUtil.getAppName(request);
        Timestamp time = TimeUtils.getCurrentTime();
        Map<String, Object> saveResult = this.persistService.batchInsertOrUpdate(configInfoList4Clone, srcUser, srcIp, null, time, false, policy);
        for (ConfigInfo configInfo : configInfoList4Clone) {
            EventDispatcher.fireEvent(new ConfigDataChangeEvent(false, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), time.getTime()));
            ConfigTraceService.logPersistenceEvent(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), requestIpApp, time.getTime(), SystemUtils.LOCAL_IP, "pub", configInfo.getContent());
        }
        return ResultBuilder.buildSuccessResult("\u5bfc\u5165\u6210\u529f", saveResult);
    }
}

