/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.controller;

import com.alibaba.nacos.config.server.service.DataSourceService;
import com.alibaba.nacos.config.server.service.DynamicDataSource;
import com.alibaba.nacos.config.server.service.ServerListService;
import com.alibaba.nacos.core.utils.SystemUtils;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/v1/cs/health"})
public class HealthController {
    private final DynamicDataSource dynamicDataSource;
    private DataSourceService dataSourceService;
    private String heathUpStr = "UP";
    private String heathDownStr = "DOWN";
    private String heathWarnStr = "WARN";

    @Autowired
    public HealthController(DynamicDataSource dynamicDataSource) {
        this.dynamicDataSource = dynamicDataSource;
    }

    @PostConstruct
    public void init() {
        this.dataSourceService = this.dynamicDataSource.getDataSource();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.GET})
    public String getHealth() {
        StringBuilder sb = new StringBuilder();
        String dbStatus = this.dataSourceService.getHealth();
        if (dbStatus.contains(this.heathUpStr) && ServerListService.isAddressServerHealth() && ServerListService.isInIpList()) {
            sb.append(this.heathUpStr);
        } else if (dbStatus.contains(this.heathWarnStr) && ServerListService.isAddressServerHealth() && ServerListService.isInIpList()) {
            sb.append("WARN:");
            sb.append("slave db (").append(dbStatus.split(":")[1]).append(") down. ");
        } else {
            sb.append("DOWN:");
            if (dbStatus.contains(this.heathDownStr)) {
                sb.append("master db (").append(dbStatus.split(":")[1]).append(") down. ");
            }
            if (!ServerListService.isAddressServerHealth()) {
                sb.append("address server down. ");
            }
            if (!ServerListService.isInIpList()) {
                sb.append("server ip ").append(SystemUtils.LOCAL_IP).append(" is not in the serverList of address server. ");
            }
        }
        return sb.toString();
    }
}

