/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.result;

import com.alibaba.nacos.config.server.model.RestResult;
import com.alibaba.nacos.config.server.result.code.ResultCodeEnum;
import com.alibaba.nacos.config.server.result.core.IResultCode;
import org.springframework.util.Assert;

public class ResultBuilder {
    public static <T> RestResult<T> buildResult(IResultCode resultCode, T resultData) {
        Assert.notNull((Object)resultCode, (String)"the resultCode can not be null");
        RestResult<T> rr = new RestResult<T>(resultCode.getCode(), resultCode.getCodeMsg(), resultData);
        return rr;
    }

    public static <T> RestResult<T> buildSuccessResult(T resultData) {
        return ResultBuilder.buildResult(ResultCodeEnum.SUCCESS, resultData);
    }

    public static <T> RestResult<T> buildSuccessResult(String successMsg, T resultData) {
        RestResult<T> rr = ResultBuilder.buildResult(ResultCodeEnum.SUCCESS, resultData);
        rr.setMessage(successMsg);
        return rr;
    }

    public static <T> RestResult<T> buildSuccessResult() {
        return ResultBuilder.buildResult(ResultCodeEnum.SUCCESS, null);
    }

    public static <T> RestResult<T> buildSuccessResult(String successMsg) {
        RestResult<Object> rr = ResultBuilder.buildResult(ResultCodeEnum.SUCCESS, null);
        rr.setMessage(successMsg);
        return rr;
    }
}

