/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.RegexParser;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class AggrWhitelist {
    public static final String AGGRIDS_METADATA = "com.alibaba.nacos.metadata.aggrIDs";
    static final AtomicReference<List<Pattern>> AGGR_DATAID_WHITELIST = new AtomicReference(new ArrayList());

    public static boolean isAggrDataId(String dataId) {
        if (null == dataId) {
            throw new IllegalArgumentException();
        }
        for (Pattern pattern : AGGR_DATAID_WHITELIST.get()) {
            if (!pattern.matcher(dataId).matches()) continue;
            return true;
        }
        return false;
    }

    public static void load(String content) {
        if (StringUtils.isBlank((CharSequence)content)) {
            LogUtil.fatalLog.error("aggr dataId whitelist is blank.");
            return;
        }
        LogUtil.defaultLog.warn("[aggr-dataIds] {}", (Object)content);
        try {
            List lines = IOUtils.readLines((Reader)new StringReader(content));
            AggrWhitelist.compile(lines);
        }
        catch (Exception ioe) {
            LogUtil.defaultLog.error("failed to load aggr whitelist, " + ioe.toString(), (Throwable)ioe);
        }
    }

    static void compile(List<String> whitelist) {
        ArrayList<Pattern> list = new ArrayList<Pattern>(whitelist.size());
        for (String line : whitelist) {
            if (StringUtils.isBlank((CharSequence)line)) continue;
            String regex = RegexParser.regexFormat(line.trim());
            list.add(Pattern.compile(regex));
        }
        AGGR_DATAID_WHITELIST.set(list);
    }

    public static List<Pattern> getWhiteList() {
        return AGGR_DATAID_WHITELIST.get();
    }
}

