/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service;

import com.alibaba.nacos.config.server.service.DataSourceService;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.PropertyUtil;
import com.alibaba.nacos.config.server.utils.StringUtils;
import com.alibaba.nacos.core.utils.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.sql.DataSource;
import org.apache.commons.dbcp.BasicDataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Service(value="localDataSourceService")
public class LocalDataSourceServiceImpl
implements DataSourceService {
    private static final Logger logger = LoggerFactory.getLogger(LocalDataSourceServiceImpl.class);
    private static final String JDBC_DRIVER_NAME = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String DERBY_BASE_DIR = "data" + File.separator + "derby-data";
    private static final String USER_NAME = "nacos";
    private static final String PASSWORD = "nacos";
    private JdbcTemplate jt;
    private TransactionTemplate tjt;
    @Autowired
    private PropertyUtil propertyUtil;

    @PostConstruct
    public void init() {
        BasicDataSource ds = new BasicDataSource();
        ds.setDriverClassName(JDBC_DRIVER_NAME);
        ds.setUrl("jdbc:derby:" + SystemUtils.NACOS_HOME + File.separator + DERBY_BASE_DIR + ";create=true");
        ds.setUsername("nacos");
        ds.setPassword("nacos");
        ds.setInitialSize(20);
        ds.setMaxActive(30);
        ds.setMaxIdle(50);
        ds.setMaxWait(10000L);
        ds.setPoolPreparedStatements(true);
        ds.setTimeBetweenEvictionRunsMillis(TimeUnit.MINUTES.toMillis(10L));
        ds.setTestWhileIdle(true);
        this.jt = new JdbcTemplate();
        this.jt.setMaxRows(50000);
        this.jt.setQueryTimeout(5000);
        this.jt.setDataSource((DataSource)ds);
        DataSourceTransactionManager tm = new DataSourceTransactionManager();
        this.tjt = new TransactionTemplate((PlatformTransactionManager)tm);
        tm.setDataSource((DataSource)ds);
        this.tjt.setTimeout(5000);
        if (SystemUtils.STANDALONE_MODE) {
            LocalDataSourceServiceImpl localDataSourceServiceImpl = this;
            if (!localDataSourceServiceImpl.propertyUtil.isStandaloneUseMysql()) {
                this.reload();
            }
        }
    }

    @Override
    public void reload() {
        DataSource ds = this.jt.getDataSource();
        if (ds == null) {
            throw new RuntimeException("datasource is null");
        }
        try {
            this.execute(ds.getConnection(), "META-INF/schema.sql");
        }
        catch (Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            throw new RuntimeException("load schema.sql error." + e);
        }
    }

    @Override
    public boolean checkMasterWritable() {
        return true;
    }

    @Override
    public JdbcTemplate getJdbcTemplate() {
        return this.jt;
    }

    @Override
    public TransactionTemplate getTransactionTemplate() {
        return this.tjt;
    }

    @Override
    public String getCurrentDBUrl() {
        return "jdbc:derby:" + SystemUtils.NACOS_HOME + File.separator + DERBY_BASE_DIR + ";create=true";
    }

    @Override
    public String getHealth() {
        return "UP";
    }

    private List<String> loadSql(String sqlFile) throws Exception {
        ArrayList<String> sqlList = new ArrayList<String>();
        try (InputStream sqlFileIn = null;){
            if (StringUtils.isBlank(System.getProperty("nacos.home"))) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                URL url = classLoader.getResource(sqlFile);
                sqlFileIn = url.openStream();
            } else {
                File file = new File(System.getProperty("nacos.home") + File.separator + "conf" + File.separator + "schema.sql");
                sqlFileIn = new FileInputStream(file);
            }
            StringBuffer sqlSb = new StringBuffer();
            byte[] buff = new byte[1024];
            int byteRead = 0;
            while ((byteRead = sqlFileIn.read(buff)) != -1) {
                sqlSb.append(new String(buff, 0, byteRead, "UTF-8"));
            }
            String[] sqlArr = sqlSb.toString().split(";");
            for (int i = 0; i < sqlArr.length; ++i) {
                String sql = sqlArr[i].replaceAll("--.*", "").trim();
                if (!StringUtils.isNotEmpty(sql)) continue;
                sqlList.add(sql);
            }
            ArrayList<String> arrayList = sqlList;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Connection conn, String sqlFile) throws Exception {
        try (Statement stmt = null;){
            List<String> sqlList = this.loadSql(sqlFile);
            stmt = conn.createStatement();
            for (String sql : sqlList) {
                try {
                    stmt.execute(sql);
                }
                catch (Exception e) {
                    LogUtil.defaultLog.info(e.getMessage());
                }
            }
        }
    }
}

