/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sreworks.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.sreworks.common.util.JsonUtil;
import com.alibaba.tesla.appmanager.client.AppManagerClient;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import okhttp3.ConnectionPool;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Requests {
    private static final Logger log = LoggerFactory.getLogger(Requests.class);
    private static AppManagerClient APPMANAGER_HTTP_CLIENT = null;
    private static OkHttpClient HTTP_CLIENT = null;
    public String url;
    public JSONObject params = new JSONObject();
    public JSONObject headers = new JSONObject();
    public String postJson = "{}";
    public Boolean showLog = false;
    public Response response;
    public String responseBodyString;

    private void sendRequest(Request.Builder requestBuilder) throws IOException {
        this.response = APPMANAGER_HTTP_CLIENT != null ? APPMANAGER_HTTP_CLIENT.sendRequestSimple(requestBuilder) : HTTP_CLIENT.newCall(requestBuilder.build()).execute();
        this.responseBodyString = Objects.requireNonNull(this.response.body()).string();
    }

    private static Request.Builder createRequestBuilder(String url, JSONObject params, JSONObject headers) {
        HttpUrl.Builder queryUrl = Objects.requireNonNull(HttpUrl.parse((String)url)).newBuilder();
        for (String key : params.keySet()) {
            queryUrl.addQueryParameter(key, params.getString(key));
        }
        Request.Builder requestBuilder = new Request.Builder().url(queryUrl.build());
        for (String key : headers.keySet()) {
            requestBuilder.addHeader(key, headers.getString(key));
        }
        return requestBuilder;
    }

    public Requests(String url) {
        this.url = url;
    }

    public Requests(String url, Boolean showLog) {
        this.url = url;
        this.showLog = showLog;
    }

    public Requests url(String url) {
        this.url = url;
        return this;
    }

    public Requests params(JSONObject params) {
        this.params = params;
        return this;
    }

    public Requests params(Object ... args) {
        this.params = JsonUtil.map(args);
        return this;
    }

    public Requests headers(JSONObject headers) {
        this.headers = headers;
        return this;
    }

    public Requests headers(Object ... args) {
        this.headers = JsonUtil.map(args);
        return this;
    }

    public Requests postJson(JSONObject postJson) {
        this.postJson = JSONObject.toJSONString((Object)postJson);
        return this;
    }

    public Requests postJson(Object ... args) {
        this.postJson = JSONObject.toJSONString((Object)JsonUtil.map(args));
        return this;
    }

    public Requests postJson(String postJson) {
        this.postJson = postJson;
        return this;
    }

    public Requests isSuccessful() throws IOException {
        if (!this.response.isSuccessful()) {
            throw new IOException(String.format("response is not successful: %s; retBody: %s", this.response.toString(), this.getString()));
        }
        ResponseBody body = this.response.body();
        if (body != null) {
            JSONObject jsonObject = new JSONObject();
            try {
                jsonObject = JSONObject.parseObject((String)this.responseBodyString);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (jsonObject.getLongValue("code") >= 300L) {
                throw new IOException(String.format("response is not successful: %s; retBody: %s", this.response.toString(), this.getString()));
            }
        }
        return this;
    }

    public String getString() {
        if (this.showLog.booleanValue()) {
            log.info("SHOW_RESPONSE: " + this.responseBodyString);
        }
        return this.responseBodyString;
    }

    public <T> T getObject(Class<T> clazz) throws IOException {
        return (T)JSONObject.parseObject((String)this.getString(), clazz);
    }

    public JSONObject getJSONObject() throws IOException {
        return this.getObject(JSONObject.class);
    }

    public JSONArray getJSONArray() throws IOException {
        return this.getObject(JSONArray.class);
    }

    public <T> List<T> getJSONArray(Class<T> clazz) throws IOException {
        return this.getObject(JSONArray.class).toJavaList(clazz);
    }

    public Boolean getBoolean() throws IOException {
        return this.getObject(Boolean.class);
    }

    public Requests get() throws IOException {
        Request.Builder requestBuilder = Requests.createRequestBuilder(this.url, this.params, this.headers);
        this.sendRequest(requestBuilder.get());
        return this;
    }

    public Requests post() throws IOException {
        Request.Builder requestBuilder = Requests.createRequestBuilder(this.url, this.params, this.headers);
        this.sendRequest(requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.postJson)));
        return this;
    }

    public Requests upload(File file) throws IOException {
        Request.Builder requestBuilder = Requests.createRequestBuilder(this.url, this.params, this.headers);
        this.sendRequest(requestBuilder.post(RequestBody.create((MediaType)MediaType.parse((String)"application/octet-stream"), (File)file)));
        return this;
    }

    public Requests put() throws IOException {
        Request.Builder requestBuilder = Requests.createRequestBuilder(this.url, this.params, this.headers);
        this.sendRequest(requestBuilder.put(RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)this.postJson)));
        return this;
    }

    public Requests delete() throws IOException {
        Request.Builder requestBuilder = Requests.createRequestBuilder(this.url, this.params, this.headers);
        this.sendRequest(requestBuilder.delete());
        return this;
    }

    public String getUrl() {
        return this.url;
    }

    public JSONObject getParams() {
        return this.params;
    }

    public JSONObject getHeaders() {
        return this.headers;
    }

    public String getPostJson() {
        return this.postJson;
    }

    public Boolean getShowLog() {
        return this.showLog;
    }

    public Response getResponse() {
        return this.response;
    }

    public String getResponseBodyString() {
        return this.responseBodyString;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setParams(JSONObject params) {
        this.params = params;
    }

    public void setHeaders(JSONObject headers) {
        this.headers = headers;
    }

    public void setPostJson(String postJson) {
        this.postJson = postJson;
    }

    public void setShowLog(Boolean showLog) {
        this.showLog = showLog;
    }

    public void setResponse(Response response) {
        this.response = response;
    }

    public void setResponseBodyString(String responseBodyString) {
        this.responseBodyString = responseBodyString;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Requests)) {
            return false;
        }
        Requests other = (Requests)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        JSONObject this$params = this.getParams();
        JSONObject other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        JSONObject this$headers = this.getHeaders();
        JSONObject other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !this$headers.equals(other$headers)) {
            return false;
        }
        String this$postJson = this.getPostJson();
        String other$postJson = other.getPostJson();
        if (this$postJson == null ? other$postJson != null : !this$postJson.equals(other$postJson)) {
            return false;
        }
        Boolean this$showLog = this.getShowLog();
        Boolean other$showLog = other.getShowLog();
        if (this$showLog == null ? other$showLog != null : !((Object)this$showLog).equals(other$showLog)) {
            return false;
        }
        Response this$response = this.getResponse();
        Response other$response = other.getResponse();
        if (this$response == null ? other$response != null : !this$response.equals(other$response)) {
            return false;
        }
        String this$responseBodyString = this.getResponseBodyString();
        String other$responseBodyString = other.getResponseBodyString();
        return !(this$responseBodyString == null ? other$responseBodyString != null : !this$responseBodyString.equals(other$responseBodyString));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Requests;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        JSONObject $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        JSONObject $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : $headers.hashCode());
        String $postJson = this.getPostJson();
        result = result * 59 + ($postJson == null ? 43 : $postJson.hashCode());
        Boolean $showLog = this.getShowLog();
        result = result * 59 + ($showLog == null ? 43 : ((Object)$showLog).hashCode());
        Response $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : $response.hashCode());
        String $responseBodyString = this.getResponseBodyString();
        result = result * 59 + ($responseBodyString == null ? 43 : $responseBodyString.hashCode());
        return result;
    }

    public String toString() {
        return "Requests(url=" + this.getUrl() + ", params=" + this.getParams() + ", headers=" + this.getHeaders() + ", postJson=" + this.getPostJson() + ", showLog=" + this.getShowLog() + ", response=" + this.getResponse() + ", responseBodyString=" + this.getResponseBodyString() + ")";
    }

    public Requests() {
    }

    static {
        if (System.getenv("APPMANAGER_ENDPOINT") != null) {
            APPMANAGER_HTTP_CLIENT = new AppManagerClient(System.getenv("APPMANAGER_ENDPOINT"), System.getenv("APPMANAGER_USERNAME"), System.getenv("APPMANAGER_PASSWORD"), System.getenv("APPMANAGER_CLIENT_ID"), System.getenv("APPMANAGER_CLIENT_SECRET"));
        } else {
            HTTP_CLIENT = new OkHttpClient.Builder().connectionPool(new ConnectionPool()).build();
        }
    }
}

