/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sreworks.domain.DO;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.sreworks.domain.DO.App;
import com.alibaba.sreworks.domain.DO.AppComponent;
import java.util.List;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class AppPackage {
    private static final Logger log = LoggerFactory.getLogger(AppPackage.class);
    @Id
    @GeneratedValue
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column
    private String creator;
    @Column
    private String lastModifier;
    @Column
    private Long appId;
    @Column(columnDefinition="longtext")
    private String app;
    @Column(columnDefinition="longtext")
    private String appComponentList;
    @Column
    private Long appPackageTaskId;
    @Column
    private String simpleVersion;
    @Column
    private String version;
    @Column
    private String status;
    @Column
    private Long appPackageId;
    @Column
    private Integer onSale;
    @Column(columnDefinition="text")
    private String description;

    public Boolean onSale() {
        return this.onSale != null && this.onSale > 0;
    }

    public JSONObject toJsonObject() {
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)this));
    }

    public App app() {
        return (App)JSONObject.parseObject((String)this.app, App.class);
    }

    public List<AppComponent> appComponentList() {
        return JSONObject.parseArray((String)this.appComponentList).toJavaList(AppComponent.class);
    }

    public AppPackage(String operator, App app, List<AppComponent> appComponentList, Long appPackageTaskId, String simpleVersion) {
        this.gmtCreate = System.currentTimeMillis() / 1000L;
        this.gmtModified = System.currentTimeMillis() / 1000L;
        this.creator = operator;
        this.lastModifier = operator;
        this.appId = app.getId();
        this.app = JSONObject.toJSONString((Object)app);
        this.appComponentList = JSONObject.toJSONString(appComponentList);
        this.appPackageTaskId = appPackageTaskId;
        this.simpleVersion = simpleVersion;
    }

    public static AppPackageBuilder builder() {
        return new AppPackageBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    public Long getGmtModified() {
        return this.gmtModified;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public Long getAppId() {
        return this.appId;
    }

    public String getApp() {
        return this.app;
    }

    public String getAppComponentList() {
        return this.appComponentList;
    }

    public Long getAppPackageTaskId() {
        return this.appPackageTaskId;
    }

    public String getSimpleVersion() {
        return this.simpleVersion;
    }

    public String getVersion() {
        return this.version;
    }

    public String getStatus() {
        return this.status;
    }

    public Long getAppPackageId() {
        return this.appPackageId;
    }

    public Integer getOnSale() {
        return this.onSale;
    }

    public String getDescription() {
        return this.description;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setApp(String app) {
        this.app = app;
    }

    public void setAppComponentList(String appComponentList) {
        this.appComponentList = appComponentList;
    }

    public void setAppPackageTaskId(Long appPackageTaskId) {
        this.appPackageTaskId = appPackageTaskId;
    }

    public void setSimpleVersion(String simpleVersion) {
        this.simpleVersion = simpleVersion;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setAppPackageId(Long appPackageId) {
        this.appPackageId = appPackageId;
    }

    public void setOnSale(Integer onSale) {
        this.onSale = onSale;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppPackage)) {
            return false;
        }
        AppPackage other = (AppPackage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$lastModifier = this.getLastModifier();
        String other$lastModifier = other.getLastModifier();
        if (this$lastModifier == null ? other$lastModifier != null : !this$lastModifier.equals(other$lastModifier)) {
            return false;
        }
        Long this$appId = this.getAppId();
        Long other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        String this$app = this.getApp();
        String other$app = other.getApp();
        if (this$app == null ? other$app != null : !this$app.equals(other$app)) {
            return false;
        }
        String this$appComponentList = this.getAppComponentList();
        String other$appComponentList = other.getAppComponentList();
        if (this$appComponentList == null ? other$appComponentList != null : !this$appComponentList.equals(other$appComponentList)) {
            return false;
        }
        Long this$appPackageTaskId = this.getAppPackageTaskId();
        Long other$appPackageTaskId = other.getAppPackageTaskId();
        if (this$appPackageTaskId == null ? other$appPackageTaskId != null : !((Object)this$appPackageTaskId).equals(other$appPackageTaskId)) {
            return false;
        }
        String this$simpleVersion = this.getSimpleVersion();
        String other$simpleVersion = other.getSimpleVersion();
        if (this$simpleVersion == null ? other$simpleVersion != null : !this$simpleVersion.equals(other$simpleVersion)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        Long this$appPackageId = this.getAppPackageId();
        Long other$appPackageId = other.getAppPackageId();
        if (this$appPackageId == null ? other$appPackageId != null : !((Object)this$appPackageId).equals(other$appPackageId)) {
            return false;
        }
        Integer this$onSale = this.getOnSale();
        Integer other$onSale = other.getOnSale();
        if (this$onSale == null ? other$onSale != null : !((Object)this$onSale).equals(other$onSale)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        return !(this$description == null ? other$description != null : !this$description.equals(other$description));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppPackage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $lastModifier = this.getLastModifier();
        result = result * 59 + ($lastModifier == null ? 43 : $lastModifier.hashCode());
        Long $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        String $app = this.getApp();
        result = result * 59 + ($app == null ? 43 : $app.hashCode());
        String $appComponentList = this.getAppComponentList();
        result = result * 59 + ($appComponentList == null ? 43 : $appComponentList.hashCode());
        Long $appPackageTaskId = this.getAppPackageTaskId();
        result = result * 59 + ($appPackageTaskId == null ? 43 : ((Object)$appPackageTaskId).hashCode());
        String $simpleVersion = this.getSimpleVersion();
        result = result * 59 + ($simpleVersion == null ? 43 : $simpleVersion.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        Long $appPackageId = this.getAppPackageId();
        result = result * 59 + ($appPackageId == null ? 43 : ((Object)$appPackageId).hashCode());
        Integer $onSale = this.getOnSale();
        result = result * 59 + ($onSale == null ? 43 : ((Object)$onSale).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        return result;
    }

    public String toString() {
        return "AppPackage(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", creator=" + this.getCreator() + ", lastModifier=" + this.getLastModifier() + ", appId=" + this.getAppId() + ", app=" + this.getApp() + ", appComponentList=" + this.getAppComponentList() + ", appPackageTaskId=" + this.getAppPackageTaskId() + ", simpleVersion=" + this.getSimpleVersion() + ", version=" + this.getVersion() + ", status=" + this.getStatus() + ", appPackageId=" + this.getAppPackageId() + ", onSale=" + this.getOnSale() + ", description=" + this.getDescription() + ")";
    }

    public AppPackage(Long id, Long gmtCreate, Long gmtModified, String creator, String lastModifier, Long appId, String app, String appComponentList, Long appPackageTaskId, String simpleVersion, String version, String status, Long appPackageId, Integer onSale, String description) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.creator = creator;
        this.lastModifier = lastModifier;
        this.appId = appId;
        this.app = app;
        this.appComponentList = appComponentList;
        this.appPackageTaskId = appPackageTaskId;
        this.simpleVersion = simpleVersion;
        this.version = version;
        this.status = status;
        this.appPackageId = appPackageId;
        this.onSale = onSale;
        this.description = description;
    }

    public AppPackage() {
    }

    public static class AppPackageBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private String creator;
        private String lastModifier;
        private Long appId;
        private String app;
        private String appComponentList;
        private Long appPackageTaskId;
        private String simpleVersion;
        private String version;
        private String status;
        private Long appPackageId;
        private Integer onSale;
        private String description;

        AppPackageBuilder() {
        }

        public AppPackageBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AppPackageBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AppPackageBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public AppPackageBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AppPackageBuilder lastModifier(String lastModifier) {
            this.lastModifier = lastModifier;
            return this;
        }

        public AppPackageBuilder appId(Long appId) {
            this.appId = appId;
            return this;
        }

        public AppPackageBuilder app(String app) {
            this.app = app;
            return this;
        }

        public AppPackageBuilder appComponentList(String appComponentList) {
            this.appComponentList = appComponentList;
            return this;
        }

        public AppPackageBuilder appPackageTaskId(Long appPackageTaskId) {
            this.appPackageTaskId = appPackageTaskId;
            return this;
        }

        public AppPackageBuilder simpleVersion(String simpleVersion) {
            this.simpleVersion = simpleVersion;
            return this;
        }

        public AppPackageBuilder version(String version) {
            this.version = version;
            return this;
        }

        public AppPackageBuilder status(String status) {
            this.status = status;
            return this;
        }

        public AppPackageBuilder appPackageId(Long appPackageId) {
            this.appPackageId = appPackageId;
            return this;
        }

        public AppPackageBuilder onSale(Integer onSale) {
            this.onSale = onSale;
            return this;
        }

        public AppPackageBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AppPackage build() {
            return new AppPackage(this.id, this.gmtCreate, this.gmtModified, this.creator, this.lastModifier, this.appId, this.app, this.appComponentList, this.appPackageTaskId, this.simpleVersion, this.version, this.status, this.appPackageId, this.onSale, this.description);
        }

        public String toString() {
            return "AppPackage.AppPackageBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", creator=" + this.creator + ", lastModifier=" + this.lastModifier + ", appId=" + this.appId + ", app=" + this.app + ", appComponentList=" + this.appComponentList + ", appPackageTaskId=" + this.appPackageTaskId + ", simpleVersion=" + this.simpleVersion + ", version=" + this.version + ", status=" + this.status + ", appPackageId=" + this.appPackageId + ", onSale=" + this.onSale + ", description=" + this.description + ")";
        }
    }
}

