/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sreworks.domain.DO;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.sreworks.domain.DO.AppComponent;
import com.alibaba.sreworks.domain.DO.AppInstance;
import com.alibaba.sreworks.domain.DTO.AppComponentInstanceDetail;
import com.alibaba.sreworks.domain.DTO.AppComponentType;
import com.alibaba.sreworks.domain.utils.AppUtil;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class AppComponentInstance {
    private static final Logger log = LoggerFactory.getLogger(AppComponentInstance.class);
    @Id
    @GeneratedValue
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column
    private String creator;
    @Column
    private String lastModifier;
    @Column
    private Long appInstanceId;
    @Column
    private Long appComponentId;
    @Column
    private String type;
    @Column
    private String name;
    @Column(columnDefinition="text")
    private String detail;

    public AppComponentInstance(AppInstance appInstance, AppComponent appComponent) {
        this.gmtCreate = System.currentTimeMillis() / 1000L;
        this.gmtModified = System.currentTimeMillis() / 1000L;
        this.creator = appInstance.getCreator();
        this.lastModifier = appInstance.getCreator();
        this.appInstanceId = appInstance.getId();
        this.appComponentId = appComponent.getId();
        this.name = appComponent.getName();
        this.detail = appComponent.getDetail();
    }

    public AppComponentType type() {
        return AppComponentType.valueOf(this.type);
    }

    public AppComponentInstanceDetail detail() {
        AppComponentInstanceDetail detail = (AppComponentInstanceDetail)JSONObject.parseObject((String)this.detail, AppComponentInstanceDetail.class);
        return detail == null ? new AppComponentInstanceDetail() : detail;
    }

    public String microserviceName(AppInstance appInstance) {
        return appInstance.getStageId() + "-" + AppUtil.appmanagerId(appInstance.getAppId()) + "-" + this.name;
    }

    public JSONObject toJsonObject() {
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)this));
    }

    public AppComponentInstance setMetricOn(Boolean metricOn, String user) {
        AppComponentInstanceDetail detail = this.detail();
        detail.setMetricOn(metricOn);
        this.setDetail(JSONObject.toJSONString((Object)detail));
        this.setGmtModified(System.currentTimeMillis() / 1000L);
        this.setLastModifier(user);
        return this;
    }

    public static AppComponentInstanceBuilder builder() {
        return new AppComponentInstanceBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    public Long getGmtModified() {
        return this.gmtModified;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public Long getAppInstanceId() {
        return this.appInstanceId;
    }

    public Long getAppComponentId() {
        return this.appComponentId;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getDetail() {
        return this.detail;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public void setAppInstanceId(Long appInstanceId) {
        this.appInstanceId = appInstanceId;
    }

    public void setAppComponentId(Long appComponentId) {
        this.appComponentId = appComponentId;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppComponentInstance)) {
            return false;
        }
        AppComponentInstance other = (AppComponentInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$lastModifier = this.getLastModifier();
        String other$lastModifier = other.getLastModifier();
        if (this$lastModifier == null ? other$lastModifier != null : !this$lastModifier.equals(other$lastModifier)) {
            return false;
        }
        Long this$appInstanceId = this.getAppInstanceId();
        Long other$appInstanceId = other.getAppInstanceId();
        if (this$appInstanceId == null ? other$appInstanceId != null : !((Object)this$appInstanceId).equals(other$appInstanceId)) {
            return false;
        }
        Long this$appComponentId = this.getAppComponentId();
        Long other$appComponentId = other.getAppComponentId();
        if (this$appComponentId == null ? other$appComponentId != null : !((Object)this$appComponentId).equals(other$appComponentId)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        return !(this$detail == null ? other$detail != null : !this$detail.equals(other$detail));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppComponentInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $lastModifier = this.getLastModifier();
        result = result * 59 + ($lastModifier == null ? 43 : $lastModifier.hashCode());
        Long $appInstanceId = this.getAppInstanceId();
        result = result * 59 + ($appInstanceId == null ? 43 : ((Object)$appInstanceId).hashCode());
        Long $appComponentId = this.getAppComponentId();
        result = result * 59 + ($appComponentId == null ? 43 : ((Object)$appComponentId).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        return result;
    }

    public String toString() {
        return "AppComponentInstance(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", creator=" + this.getCreator() + ", lastModifier=" + this.getLastModifier() + ", appInstanceId=" + this.getAppInstanceId() + ", appComponentId=" + this.getAppComponentId() + ", type=" + this.getType() + ", name=" + this.getName() + ", detail=" + this.getDetail() + ")";
    }

    public AppComponentInstance(Long id, Long gmtCreate, Long gmtModified, String creator, String lastModifier, Long appInstanceId, Long appComponentId, String type, String name, String detail) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.creator = creator;
        this.lastModifier = lastModifier;
        this.appInstanceId = appInstanceId;
        this.appComponentId = appComponentId;
        this.type = type;
        this.name = name;
        this.detail = detail;
    }

    public AppComponentInstance() {
    }

    public static class AppComponentInstanceBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private String creator;
        private String lastModifier;
        private Long appInstanceId;
        private Long appComponentId;
        private String type;
        private String name;
        private String detail;

        AppComponentInstanceBuilder() {
        }

        public AppComponentInstanceBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AppComponentInstanceBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AppComponentInstanceBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public AppComponentInstanceBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AppComponentInstanceBuilder lastModifier(String lastModifier) {
            this.lastModifier = lastModifier;
            return this;
        }

        public AppComponentInstanceBuilder appInstanceId(Long appInstanceId) {
            this.appInstanceId = appInstanceId;
            return this;
        }

        public AppComponentInstanceBuilder appComponentId(Long appComponentId) {
            this.appComponentId = appComponentId;
            return this;
        }

        public AppComponentInstanceBuilder type(String type) {
            this.type = type;
            return this;
        }

        public AppComponentInstanceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AppComponentInstanceBuilder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public AppComponentInstance build() {
            return new AppComponentInstance(this.id, this.gmtCreate, this.gmtModified, this.creator, this.lastModifier, this.appInstanceId, this.appComponentId, this.type, this.name, this.detail);
        }

        public String toString() {
            return "AppComponentInstance.AppComponentInstanceBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", creator=" + this.creator + ", lastModifier=" + this.lastModifier + ", appInstanceId=" + this.appInstanceId + ", appComponentId=" + this.appComponentId + ", type=" + this.type + ", name=" + this.name + ", detail=" + this.detail + ")";
        }
    }
}

