/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sreworks.domain.DO;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.sreworks.domain.DTO.AppInstanceDetail;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;
import org.springframework.util.StringUtils;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class AppInstance {
    private static final Logger log = LoggerFactory.getLogger(AppInstance.class);
    @Id
    @GeneratedValue
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column
    private String creator;
    @Column
    private String lastModifier;
    @Column
    private String name;
    @Column
    private Long teamId;
    @Column
    private Long clusterId;
    @Column
    private Long appId;
    @Column
    private Long appPackageId;
    @Column
    private String appDeployId;
    @Column
    private String stageId;
    @Column
    private String status;
    @Column(columnDefinition="text")
    private String detail;
    @Column(columnDefinition="text")
    private String description;
    @Column(columnDefinition="longtext")
    private String ac;

    public AppInstanceDetail detail() {
        AppInstanceDetail detail = (AppInstanceDetail)JSONObject.parseObject((String)this.detail, AppInstanceDetail.class);
        return detail == null ? new AppInstanceDetail() : detail;
    }

    public String namespace() {
        return StringUtils.isEmpty((Object)this.name) ? String.format("%s-%s", this.getStageId(), this.getId()) : this.name;
    }

    public JSONObject toJsonObject() {
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)this));
    }

    public static AppInstanceBuilder builder() {
        return new AppInstanceBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    public Long getGmtModified() {
        return this.gmtModified;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public String getName() {
        return this.name;
    }

    public Long getTeamId() {
        return this.teamId;
    }

    public Long getClusterId() {
        return this.clusterId;
    }

    public Long getAppId() {
        return this.appId;
    }

    public Long getAppPackageId() {
        return this.appPackageId;
    }

    public String getAppDeployId() {
        return this.appDeployId;
    }

    public String getStageId() {
        return this.stageId;
    }

    public String getStatus() {
        return this.status;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAc() {
        return this.ac;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public void setClusterId(Long clusterId) {
        this.clusterId = clusterId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public void setAppPackageId(Long appPackageId) {
        this.appPackageId = appPackageId;
    }

    public void setAppDeployId(String appDeployId) {
        this.appDeployId = appDeployId;
    }

    public void setStageId(String stageId) {
        this.stageId = stageId;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setAc(String ac) {
        this.ac = ac;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppInstance)) {
            return false;
        }
        AppInstance other = (AppInstance)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$lastModifier = this.getLastModifier();
        String other$lastModifier = other.getLastModifier();
        if (this$lastModifier == null ? other$lastModifier != null : !this$lastModifier.equals(other$lastModifier)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        Long this$teamId = this.getTeamId();
        Long other$teamId = other.getTeamId();
        if (this$teamId == null ? other$teamId != null : !((Object)this$teamId).equals(other$teamId)) {
            return false;
        }
        Long this$clusterId = this.getClusterId();
        Long other$clusterId = other.getClusterId();
        if (this$clusterId == null ? other$clusterId != null : !((Object)this$clusterId).equals(other$clusterId)) {
            return false;
        }
        Long this$appId = this.getAppId();
        Long other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !((Object)this$appId).equals(other$appId)) {
            return false;
        }
        Long this$appPackageId = this.getAppPackageId();
        Long other$appPackageId = other.getAppPackageId();
        if (this$appPackageId == null ? other$appPackageId != null : !((Object)this$appPackageId).equals(other$appPackageId)) {
            return false;
        }
        String this$appDeployId = this.getAppDeployId();
        String other$appDeployId = other.getAppDeployId();
        if (this$appDeployId == null ? other$appDeployId != null : !this$appDeployId.equals(other$appDeployId)) {
            return false;
        }
        String this$stageId = this.getStageId();
        String other$stageId = other.getStageId();
        if (this$stageId == null ? other$stageId != null : !this$stageId.equals(other$stageId)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$ac = this.getAc();
        String other$ac = other.getAc();
        return !(this$ac == null ? other$ac != null : !this$ac.equals(other$ac));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AppInstance;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $lastModifier = this.getLastModifier();
        result = result * 59 + ($lastModifier == null ? 43 : $lastModifier.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        Long $teamId = this.getTeamId();
        result = result * 59 + ($teamId == null ? 43 : ((Object)$teamId).hashCode());
        Long $clusterId = this.getClusterId();
        result = result * 59 + ($clusterId == null ? 43 : ((Object)$clusterId).hashCode());
        Long $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : ((Object)$appId).hashCode());
        Long $appPackageId = this.getAppPackageId();
        result = result * 59 + ($appPackageId == null ? 43 : ((Object)$appPackageId).hashCode());
        String $appDeployId = this.getAppDeployId();
        result = result * 59 + ($appDeployId == null ? 43 : $appDeployId.hashCode());
        String $stageId = this.getStageId();
        result = result * 59 + ($stageId == null ? 43 : $stageId.hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $ac = this.getAc();
        result = result * 59 + ($ac == null ? 43 : $ac.hashCode());
        return result;
    }

    public String toString() {
        return "AppInstance(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", creator=" + this.getCreator() + ", lastModifier=" + this.getLastModifier() + ", name=" + this.getName() + ", teamId=" + this.getTeamId() + ", clusterId=" + this.getClusterId() + ", appId=" + this.getAppId() + ", appPackageId=" + this.getAppPackageId() + ", appDeployId=" + this.getAppDeployId() + ", stageId=" + this.getStageId() + ", status=" + this.getStatus() + ", detail=" + this.getDetail() + ", description=" + this.getDescription() + ", ac=" + this.getAc() + ")";
    }

    public AppInstance(Long id, Long gmtCreate, Long gmtModified, String creator, String lastModifier, String name, Long teamId, Long clusterId, Long appId, Long appPackageId, String appDeployId, String stageId, String status, String detail, String description, String ac) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.creator = creator;
        this.lastModifier = lastModifier;
        this.name = name;
        this.teamId = teamId;
        this.clusterId = clusterId;
        this.appId = appId;
        this.appPackageId = appPackageId;
        this.appDeployId = appDeployId;
        this.stageId = stageId;
        this.status = status;
        this.detail = detail;
        this.description = description;
        this.ac = ac;
    }

    public AppInstance() {
    }

    public static class AppInstanceBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private String creator;
        private String lastModifier;
        private String name;
        private Long teamId;
        private Long clusterId;
        private Long appId;
        private Long appPackageId;
        private String appDeployId;
        private String stageId;
        private String status;
        private String detail;
        private String description;
        private String ac;

        AppInstanceBuilder() {
        }

        public AppInstanceBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AppInstanceBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AppInstanceBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public AppInstanceBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public AppInstanceBuilder lastModifier(String lastModifier) {
            this.lastModifier = lastModifier;
            return this;
        }

        public AppInstanceBuilder name(String name) {
            this.name = name;
            return this;
        }

        public AppInstanceBuilder teamId(Long teamId) {
            this.teamId = teamId;
            return this;
        }

        public AppInstanceBuilder clusterId(Long clusterId) {
            this.clusterId = clusterId;
            return this;
        }

        public AppInstanceBuilder appId(Long appId) {
            this.appId = appId;
            return this;
        }

        public AppInstanceBuilder appPackageId(Long appPackageId) {
            this.appPackageId = appPackageId;
            return this;
        }

        public AppInstanceBuilder appDeployId(String appDeployId) {
            this.appDeployId = appDeployId;
            return this;
        }

        public AppInstanceBuilder stageId(String stageId) {
            this.stageId = stageId;
            return this;
        }

        public AppInstanceBuilder status(String status) {
            this.status = status;
            return this;
        }

        public AppInstanceBuilder detail(String detail) {
            this.detail = detail;
            return this;
        }

        public AppInstanceBuilder description(String description) {
            this.description = description;
            return this;
        }

        public AppInstanceBuilder ac(String ac) {
            this.ac = ac;
            return this;
        }

        public AppInstance build() {
            return new AppInstance(this.id, this.gmtCreate, this.gmtModified, this.creator, this.lastModifier, this.name, this.teamId, this.clusterId, this.appId, this.appPackageId, this.appDeployId, this.stageId, this.status, this.detail, this.description, this.ac);
        }

        public String toString() {
            return "AppInstance.AppInstanceBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", creator=" + this.creator + ", lastModifier=" + this.lastModifier + ", name=" + this.name + ", teamId=" + this.teamId + ", clusterId=" + this.clusterId + ", appId=" + this.appId + ", appPackageId=" + this.appPackageId + ", appDeployId=" + this.appDeployId + ", stageId=" + this.stageId + ", status=" + this.status + ", detail=" + this.detail + ", description=" + this.description + ", ac=" + this.ac + ")";
        }
    }
}

