/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sreworks.domain.DO;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class Avatar {
    private static final Logger log = LoggerFactory.getLogger(Avatar.class);
    @Id
    @GeneratedValue
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column(columnDefinition="longblob")
    private String content;

    public Avatar(String content) {
        this.gmtCreate = System.currentTimeMillis() / 1000L;
        this.gmtModified = System.currentTimeMillis() / 1000L;
        this.content = content;
    }

    public static AvatarBuilder builder() {
        return new AvatarBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    public Long getGmtModified() {
        return this.gmtModified;
    }

    public String getContent() {
        return this.content;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Avatar)) {
            return false;
        }
        Avatar other = (Avatar)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        return !(this$content == null ? other$content != null : !this$content.equals(other$content));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Avatar;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        return result;
    }

    public String toString() {
        return "Avatar(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", content=" + this.getContent() + ")";
    }

    public Avatar(Long id, Long gmtCreate, Long gmtModified, String content) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.content = content;
    }

    public Avatar() {
    }

    public static class AvatarBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private String content;

        AvatarBuilder() {
        }

        public AvatarBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public AvatarBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public AvatarBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public AvatarBuilder content(String content) {
            this.content = content;
            return this;
        }

        public Avatar build() {
            return new Avatar(this.id, this.gmtCreate, this.gmtModified, this.content);
        }

        public String toString() {
            return "Avatar.AvatarBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", content=" + this.content + ")";
        }
    }
}

