/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sreworks.domain.DO;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.sreworks.domain.DTO.TeamUserRole;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

@Entity
@EntityListeners(value={AuditingEntityListener.class})
public class TeamUser {
    private static final Logger log = LoggerFactory.getLogger(TeamUser.class);
    @Id
    @GeneratedValue
    private Long id;
    @Column
    private Long gmtCreate;
    @Column
    private Long gmtModified;
    @Column
    private Long gmtAccess;
    @Column
    private Long teamId;
    @Column
    private String user;
    @Column
    private String role;
    @Column
    private String creator;
    @Column
    private String lastModifier;
    @Column
    private Integer isConcern;

    public TeamUserRole role() {
        return TeamUserRole.valueOf(this.getRole());
    }

    public TeamUser(Long teamId, String user) {
        this.gmtCreate = System.currentTimeMillis() / 1000L;
        this.gmtModified = System.currentTimeMillis() / 1000L;
        this.gmtAccess = System.currentTimeMillis() / 1000L;
        this.teamId = teamId;
        this.user = user;
        this.creator = user;
        this.lastModifier = user;
        this.isConcern = 0;
    }

    public JSONObject toJsonObject() {
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)this));
    }

    public static TeamUserBuilder builder() {
        return new TeamUserBuilder();
    }

    public Long getId() {
        return this.id;
    }

    public Long getGmtCreate() {
        return this.gmtCreate;
    }

    public Long getGmtModified() {
        return this.gmtModified;
    }

    public Long getGmtAccess() {
        return this.gmtAccess;
    }

    public Long getTeamId() {
        return this.teamId;
    }

    public String getUser() {
        return this.user;
    }

    public String getRole() {
        return this.role;
    }

    public String getCreator() {
        return this.creator;
    }

    public String getLastModifier() {
        return this.lastModifier;
    }

    public Integer getIsConcern() {
        return this.isConcern;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setGmtCreate(Long gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public void setGmtModified(Long gmtModified) {
        this.gmtModified = gmtModified;
    }

    public void setGmtAccess(Long gmtAccess) {
        this.gmtAccess = gmtAccess;
    }

    public void setTeamId(Long teamId) {
        this.teamId = teamId;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setRole(String role) {
        this.role = role;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public void setLastModifier(String lastModifier) {
        this.lastModifier = lastModifier;
    }

    public void setIsConcern(Integer isConcern) {
        this.isConcern = isConcern;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TeamUser)) {
            return false;
        }
        TeamUser other = (TeamUser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$gmtCreate = this.getGmtCreate();
        Long other$gmtCreate = other.getGmtCreate();
        if (this$gmtCreate == null ? other$gmtCreate != null : !((Object)this$gmtCreate).equals(other$gmtCreate)) {
            return false;
        }
        Long this$gmtModified = this.getGmtModified();
        Long other$gmtModified = other.getGmtModified();
        if (this$gmtModified == null ? other$gmtModified != null : !((Object)this$gmtModified).equals(other$gmtModified)) {
            return false;
        }
        Long this$gmtAccess = this.getGmtAccess();
        Long other$gmtAccess = other.getGmtAccess();
        if (this$gmtAccess == null ? other$gmtAccess != null : !((Object)this$gmtAccess).equals(other$gmtAccess)) {
            return false;
        }
        Long this$teamId = this.getTeamId();
        Long other$teamId = other.getTeamId();
        if (this$teamId == null ? other$teamId != null : !((Object)this$teamId).equals(other$teamId)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$role = this.getRole();
        String other$role = other.getRole();
        if (this$role == null ? other$role != null : !this$role.equals(other$role)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$lastModifier = this.getLastModifier();
        String other$lastModifier = other.getLastModifier();
        if (this$lastModifier == null ? other$lastModifier != null : !this$lastModifier.equals(other$lastModifier)) {
            return false;
        }
        Integer this$isConcern = this.getIsConcern();
        Integer other$isConcern = other.getIsConcern();
        return !(this$isConcern == null ? other$isConcern != null : !((Object)this$isConcern).equals(other$isConcern));
    }

    protected boolean canEqual(Object other) {
        return other instanceof TeamUser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $gmtCreate = this.getGmtCreate();
        result = result * 59 + ($gmtCreate == null ? 43 : ((Object)$gmtCreate).hashCode());
        Long $gmtModified = this.getGmtModified();
        result = result * 59 + ($gmtModified == null ? 43 : ((Object)$gmtModified).hashCode());
        Long $gmtAccess = this.getGmtAccess();
        result = result * 59 + ($gmtAccess == null ? 43 : ((Object)$gmtAccess).hashCode());
        Long $teamId = this.getTeamId();
        result = result * 59 + ($teamId == null ? 43 : ((Object)$teamId).hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $role = this.getRole();
        result = result * 59 + ($role == null ? 43 : $role.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $lastModifier = this.getLastModifier();
        result = result * 59 + ($lastModifier == null ? 43 : $lastModifier.hashCode());
        Integer $isConcern = this.getIsConcern();
        result = result * 59 + ($isConcern == null ? 43 : ((Object)$isConcern).hashCode());
        return result;
    }

    public String toString() {
        return "TeamUser(id=" + this.getId() + ", gmtCreate=" + this.getGmtCreate() + ", gmtModified=" + this.getGmtModified() + ", gmtAccess=" + this.getGmtAccess() + ", teamId=" + this.getTeamId() + ", user=" + this.getUser() + ", role=" + this.getRole() + ", creator=" + this.getCreator() + ", lastModifier=" + this.getLastModifier() + ", isConcern=" + this.getIsConcern() + ")";
    }

    public TeamUser(Long id, Long gmtCreate, Long gmtModified, Long gmtAccess, Long teamId, String user, String role, String creator, String lastModifier, Integer isConcern) {
        this.id = id;
        this.gmtCreate = gmtCreate;
        this.gmtModified = gmtModified;
        this.gmtAccess = gmtAccess;
        this.teamId = teamId;
        this.user = user;
        this.role = role;
        this.creator = creator;
        this.lastModifier = lastModifier;
        this.isConcern = isConcern;
    }

    public TeamUser() {
    }

    public static class TeamUserBuilder {
        private Long id;
        private Long gmtCreate;
        private Long gmtModified;
        private Long gmtAccess;
        private Long teamId;
        private String user;
        private String role;
        private String creator;
        private String lastModifier;
        private Integer isConcern;

        TeamUserBuilder() {
        }

        public TeamUserBuilder id(Long id) {
            this.id = id;
            return this;
        }

        public TeamUserBuilder gmtCreate(Long gmtCreate) {
            this.gmtCreate = gmtCreate;
            return this;
        }

        public TeamUserBuilder gmtModified(Long gmtModified) {
            this.gmtModified = gmtModified;
            return this;
        }

        public TeamUserBuilder gmtAccess(Long gmtAccess) {
            this.gmtAccess = gmtAccess;
            return this;
        }

        public TeamUserBuilder teamId(Long teamId) {
            this.teamId = teamId;
            return this;
        }

        public TeamUserBuilder user(String user) {
            this.user = user;
            return this;
        }

        public TeamUserBuilder role(String role) {
            this.role = role;
            return this;
        }

        public TeamUserBuilder creator(String creator) {
            this.creator = creator;
            return this;
        }

        public TeamUserBuilder lastModifier(String lastModifier) {
            this.lastModifier = lastModifier;
            return this;
        }

        public TeamUserBuilder isConcern(Integer isConcern) {
            this.isConcern = isConcern;
            return this;
        }

        public TeamUser build() {
            return new TeamUser(this.id, this.gmtCreate, this.gmtModified, this.gmtAccess, this.teamId, this.user, this.role, this.creator, this.lastModifier, this.isConcern);
        }

        public String toString() {
            return "TeamUser.TeamUserBuilder(id=" + this.id + ", gmtCreate=" + this.gmtCreate + ", gmtModified=" + this.gmtModified + ", gmtAccess=" + this.gmtAccess + ", teamId=" + this.teamId + ", user=" + this.user + ", role=" + this.role + ", creator=" + this.creator + ", lastModifier=" + this.lastModifier + ", isConcern=" + this.isConcern + ")";
        }
    }
}

