/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sreworks.domain.DTO;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.sreworks.domain.DTO.CpuMemResource;
import io.kubernetes.client.custom.Quantity;
import io.kubernetes.client.openapi.models.V1ResourceQuotaSpec;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Resource {
    private static final Logger log = LoggerFactory.getLogger(Resource.class);
    private CpuMemResource limits;
    private CpuMemResource requests;

    public JSONObject toJsonObject() {
        return JSONObject.parseObject((String)JSONObject.toJSONString((Object)this));
    }

    public V1ResourceQuotaSpec toV1ResourceQuotaSpec() {
        V1ResourceQuotaSpec spec = new V1ResourceQuotaSpec().hard(new HashMap());
        if (this.limits != null) {
            if (this.limits.getCpu() != null) {
                spec.putHardItem("limits.cpu", Quantity.fromString((String)this.limits.getCpu()));
            }
            if (this.limits.getMemory() != null) {
                spec.putHardItem("limits.memory", Quantity.fromString((String)this.limits.getMemory()));
            }
        }
        if (this.requests != null) {
            if (this.requests.getCpu() != null) {
                spec.putHardItem("requests.cpu", Quantity.fromString((String)this.requests.getCpu()));
            }
            if (this.requests.getMemory() != null) {
                spec.putHardItem("requests.memory", Quantity.fromString((String)this.requests.getMemory()));
            }
        }
        return spec;
    }

    public static ResourceBuilder builder() {
        return new ResourceBuilder();
    }

    public CpuMemResource getLimits() {
        return this.limits;
    }

    public CpuMemResource getRequests() {
        return this.requests;
    }

    public void setLimits(CpuMemResource limits) {
        this.limits = limits;
    }

    public void setRequests(CpuMemResource requests) {
        this.requests = requests;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource other = (Resource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CpuMemResource this$limits = this.getLimits();
        CpuMemResource other$limits = other.getLimits();
        if (this$limits == null ? other$limits != null : !((Object)this$limits).equals(other$limits)) {
            return false;
        }
        CpuMemResource this$requests = this.getRequests();
        CpuMemResource other$requests = other.getRequests();
        return !(this$requests == null ? other$requests != null : !((Object)this$requests).equals(other$requests));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Resource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CpuMemResource $limits = this.getLimits();
        result = result * 59 + ($limits == null ? 43 : ((Object)$limits).hashCode());
        CpuMemResource $requests = this.getRequests();
        result = result * 59 + ($requests == null ? 43 : ((Object)$requests).hashCode());
        return result;
    }

    public String toString() {
        return "Resource(limits=" + this.getLimits() + ", requests=" + this.getRequests() + ")";
    }

    public Resource() {
    }

    public Resource(CpuMemResource limits, CpuMemResource requests) {
        this.limits = limits;
        this.requests = requests;
    }

    public static class ResourceBuilder {
        private CpuMemResource limits;
        private CpuMemResource requests;

        ResourceBuilder() {
        }

        public ResourceBuilder limits(CpuMemResource limits) {
            this.limits = limits;
            return this;
        }

        public ResourceBuilder requests(CpuMemResource requests) {
            this.requests = requests;
            return this;
        }

        public Resource build() {
            return new Resource(this.limits, this.requests);
        }

        public String toString() {
            return "Resource.ResourceBuilder(limits=" + this.limits + ", requests=" + this.requests + ")";
        }
    }
}

