package com.alibaba.tesla.dag;

import lombok.Getter;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import static java.lang.String.format;

/**
 * @author jinghua.yjh
 */

@Slf4j
@Service
public class ApplicationProperties {

    @Value("${tesla.gateway.url:}")
    public String teslaGatewayUrl;

    @Value("${tesla.check.url:}")
    public String teslaCheckUrl;

    @Value("${tesla.task.instance.format:}")
    public String teslaTaskInstance;

    @Value("${tesla.dag.localnode.reflection.prefix:com.alibaba.tesla}")
    public String teslaDagLocalnodeReflectionPrefix;

    @Value("${tesla.dag.localnode.jar.path:/home/admin/tesla-check/local/jar/}")
    public String teslaDagLocalnodeJarPath;

    @Value("${tesla.dag.localnode.runMaxSize:20}")
    public int teslaDagLocalnodeRunMaxSize;

    @Value("${dag.hot.load.jar.interval.second:2}")
    public Long dagHotLoadJarIntervalSecond;

    @Value("${dag.hot.load.jar.oss.endpoint:}")
    public String dagHotLoadJarOssEndpoint;

    @Value("${dag.hot.load.jar.oss.accessKeyId:}")
    public String dagHotLoadJarOssAccessKeyId;

    @Value("${dag.hot.load.jar.oss.accessKeySecret:}")
    public String dagHotLoadJarOssAccessKeySecret;

    @Value("${dag.hot.load.jar.oss.bucket.name:}")
    public String dagHotLoadJarOssBucketName;

    @Value("${dag.hot.load.jar.minio.endpoint:}")
    public String dagHotLoadJarMinioEndpoint;

    @Value("${dag.hot.load.jar.minio.accessKeyId:}")
    public String dagHotLoadJarMinioAccessKeyId;

    @Value("${dag.hot.load.jar.minio.accessKeySecret:}")
    public String dagHotLoadJarMinioAccessKeySecret;

    @Value("${dag.hot.load.jar.minio.bucket.name:}")
    public String dagHotLoadJarMinioBucketName;

    @Value("${dag.usage.mode:}")
    private String dagUseMode;

    @Getter
    @Value("${tesla.gateway.endpoint:}")
    private String teslaGatewayEndpoint;

    public boolean isJarUseMode(){
        return StringUtils.equals(dagUseMode, "jar");
    }

    public String teslaGatewayUrl(String env, String appId, String faasName) {
        if (StringUtils.isEmpty(env)) {
            env = "";
        }
        String urlHeader = "gateway.tesla.alibaba-inc.com";
        switch (env) {
            case "pre":
                urlHeader = "gateway-pre.tesla.alibaba-inc.com";
                break;
            case "daily":
                urlHeader = "gateway-daily.tesla.alibaba-inc.com";
                break;
            default:
                break;
        }
        return format(teslaGatewayUrl, urlHeader, appId, faasName);
    }

    public String teslaTaskInstance(String appId, String taskId) {
        return format(teslaTaskInstance, appId, taskId);
    }
}
