package com.alibaba.tesla.dag.accordion;

import java.util.Arrays;

import com.alibaba.fastjson.JSONObject;

/**
 * @author jinghua.yjh
 */
public class AccordionTestMain {

    public static void main(String[] args) {
        CommonDiagnoseComponent commonDiagnoseComponent = CommonDiagnoseComponent.builder()
            .summary(
                CommonKvComponent.builder()
                    .submitter("sub")
                    .stime(11L)
                    .etime(22L)
                    .status("OK")
                    .build()
            )
            .build();
        commonDiagnoseComponent.steps.add(CommonDiagnoseStep.builder()
            .name("name")
            .status("status")
            .logInfo("loginfo")
            .detail(Arrays.asList(
                BaseWidgetJsxComponent.builder().text("text1").build(),
                BaseWidgetJsxComponent.builder().text("text2").build(),
                CommonDiagnoseComponent.builder()
                    .summary(
                        CommonKvComponent.builder()
                            .submitter("sub")
                            .stime(11L)
                            .etime(22L)
                            .status("OK")
                            .build()
                    )
                    .build()
            ))
            .build());
        System.out.println(JSONObject.toJSONString(
            commonDiagnoseComponent.toMap()
            , true));
    }

}
