package com.alibaba.tesla.dag.accordion;

import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Builder.Default;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import static java.lang.String.format;

/**
 * @author jinghua.yjh
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BaseWidgetComponent implements ComponentInterface {

    String formatDetail;

    @Override
    public Map<String, Object> toMap() {
        Object props = StringUtils.isNotEmpty(formatDetail) ? JSONObject.parse(formatDetail) : new JSONObject();
        props = props == null ? new JSONObject() : props;
        return ImmutableMap.of(
            "component", "BaseWidget",
            "props", props
        );
    }
}
