package com.alibaba.tesla.dag.accordion;

import java.util.Map;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Builder.Default;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

import static java.lang.String.format;

/**
 * @author jinghua.yjh
 */
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class BaseWidgetJsxComponent implements ComponentInterface {

    @Default
    String text = "";

    @Default
    String type = "pre";

    public BaseWidgetJsxComponent addErrorToText(Exception e) {
        addText(Throwables.getStackTraceAsString(e), "\n");
        return this;
    }

    public BaseWidgetJsxComponent addText(String text) {
        addText(text, "");
        return this;
    }

    public BaseWidgetJsxComponent addText(String text, String join) {
        if (StringUtils.isNotEmpty(text)) {
            this.text += join;
        }
        this.text += text.replace("<", "&lt;").replace(">", "&gt;");
        return this;
    }

    public BaseWidgetJsxComponent addHtmlText(String text) {
        addHtmlText(text, "");
        return this;
    }

    public BaseWidgetJsxComponent addHtmlText(String text, String join) {
        if (StringUtils.isNotEmpty(text)) {
            this.text += join;
        }
        this.text += text;
        return this;
    }

    @Override
    public Map<String, Object> toMap() {
        return ImmutableMap.of(
            "component", "BaseWidget",
            "props", ImmutableMap.of(
                "config", ImmutableMap.of(
                    "jsx", format("<%s>%s</%s>", type, text, type)
                ),
                "type", "JSX"
            )
        );
    }
}
