package com.alibaba.tesla.dag.accordion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Builder.Default;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author jinghua.yjh
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CommonDiagnoseComponent implements ComponentInterface {

    @Default
    CommonKvComponent summary = new CommonKvComponent();

    @Default
    List<CommonDiagnoseStep> steps = new ArrayList<>();

    @Override
    public Map<String, Object> toMap() {
        return ImmutableMap.of(
            "component", "CommonDiagnoseComponent",
            "props", ImmutableMap.of(
                "summary", summary.toMap(),
                "steps", steps.stream().map(CommonDiagnoseStep::toMap).collect(Collectors.toList())
            )
        );
    }

}
