package com.alibaba.tesla.dag.accordion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

/**
 * @author jinghua.yjh
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CommonDiagnoseStep {

    String name;

    String status;

    String logInfo;

    String description;

    String nodeId;

    @Builder.Default
    List<ComponentInterface> detail = new ArrayList<>();

    public Map<String, Object> toMap() {
        ImmutableMap.Builder<String, Object> builder = new ImmutableMap.Builder<String, Object>()
            .put("name", name)
            .put("status", status)
            .put("detail", detail.stream().map(ComponentInterface::toMap).collect(Collectors.toList()));
        if (StringUtils.isNotEmpty(description)) {
            builder.put("description", description);
        }
        if (StringUtils.isNotEmpty(nodeId)) {
            builder.put("nodeId", nodeId);
        }
        return builder.build();
    }

}
