package com.alibaba.tesla.dag.accordion;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Builder.Default;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author jinghua.yjh
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CommonHighchartComponent implements ComponentInterface {

    @Default
    LinkedHashMap<String, Object> data = new LinkedHashMap<>();

    private List<Object> yAxisConfig() {
        return data.keySet().stream().map(x->ImmutableMap.of(
            "name", x,
            "index", x
        )).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> toMap() {
        return ImmutableMap.of(
            "component", "CommonHighchartComponent",
            "props", ImmutableMap.of(
                "type", "line",
                "data", data,
                "config", ImmutableMap.of(
                    "title", "",
                    "yAxisConfig", yAxisConfig()
                )
            )
        );
    }

}
