package com.alibaba.tesla.dag.accordion;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.tesla.dag.common.Tools;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Builder.Default;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

/**
 * @author jinghua.yjh
 */
@Slf4j
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CommonKvComponent implements ComponentInterface {

    @Default
    List<ComponentInterface> detail = new ArrayList<>();

    @Default
    String description = "";

    @Default
    boolean isSummary = true;

    @Default
    String submitter = "";

    Long stime;

    Long etime;

    @Default
    Long estimatedDuration = 120L;

    @Default
    String status = "waiting";

    @Default
    LinkedHashMap<String, Object> kvData = new LinkedHashMap<>();

    public CommonKvComponent isSummary(boolean isSummary) {
        this.isSummary = isSummary;
        return this;
    }

    public CommonKvComponent(String submitter, Long stime, Long etime, Long estimatedDuration, String status) {
        this.submitter = submitter;
        this.stime = stime;
        this.etime = etime;
        if (estimatedDuration != null) {
            this.estimatedDuration = estimatedDuration;
        }
        this.status = status;
    }

    public CommonKvComponent addLinkKv(String name, String href, Object value) {
        kvData.put(name, ImmutableMap.of(
            "href", href,
            "type", "link",
            "value", value
        ));
        return this;
    }

    public CommonKvComponent addKv(String name, Object value) {
        kvData.put(name, value);
        return this;
    }

    private Map<String, Object> getMetaData() {
        return ImmutableMap.of(
            "submitter", submitter,
            "stime", stime != null ? Tools.timeStamp2Date(stime) : "",
            "etime", etime != null ? Tools.timeStamp2Date(etime) : "",
            "estimated_duration", estimatedDuration,
            "status", status
        );
    }

    private Map<String, Object> getAllKvData() {
        LinkedHashMap<String, Object> allData = new LinkedHashMap<>();
        if (isSummary) {
            allData.putAll(getMetaData());
        }
        allData.putAll(this.kvData);
        return allData;
    }

    @Override
    public Map<String, Object> toMap() {
        return ImmutableMap.of(
            "component", "CommonKvComponent",
            "props", ImmutableMap.of(
                "kvData", getAllKvData(),
                "colNum", 2
            ),
            "description", description,
            "detail", detail == null ? new ArrayList<>()
                : detail.stream().map(ComponentInterface::toMap).collect(Collectors.toList())
        );
    }

}
