package com.alibaba.tesla.dag.accordion;

import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Builder.Default;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author jinghua.yjh
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class CommonTableColumnDef {

    String headerName;

    String field;

    String tooltip;

    Object filter;

    boolean hide = false;

    @Default
    JSONObject render = new JSONObject();

    public CommonTableColumnDef tooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public CommonTableColumnDef span() {
        render.put("type", "span");
        return this;
    }

    public CommonTableColumnDef span(String color) {
        render.put("type", "span");
        render.put("color", color);
        return this;
    }

    public CommonTableColumnDef longText(int maxLength) {
        render.put("type", "long_text");
        render.put("maxLength", maxLength);
        return this;
    }

    public CommonTableColumnDef link(String href) {
        render.put("type", "link");
        render.put("href", href);
        return this;
    }

    public Map<String, Object> toMap() {
        Map<String, Object> map = new HashMap<>(0);
        map.put("headerName", headerName);
        map.put("field", field);
        map.put("render", render);
        map.put("tooltip", tooltip);
        map.put("filter", filter);
        map.put("hide", hide);
        return map;
    }

}
