package com.alibaba.tesla.dag.accordion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.Tools;

import com.google.common.collect.ImmutableMap;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;

/**
 * @author jinghua.yjh
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@Slf4j
public class CommonTableComponent implements ComponentInterface {

    @Builder.Default
    List<JSONObject> rowData = new ArrayList<>();

    @Builder.Default
    List<CommonTableColumnDef> columnDefs = new ArrayList<>();

    public CommonTableComponent setColumnDefs(JSONArray dataArray, JSONObject formatDetailJson) {
        formatDetailJson = CollectionUtils.isEmpty(formatDetailJson) ? new JSONObject() : formatDetailJson;
        if (!CollectionUtils.isEmpty(dataArray)) {
            LinkedHashMap map = dataArray.getObject(0, LinkedHashMap.class);
            @SuppressWarnings("unchecked")
            List<String> keys = new ArrayList<>(map.keySet());
            for (String key : keys) {
                CommonTableColumnDef columnDef = CommonTableColumnDef.builder()
                    .headerName(key)
                    .field(key)
                    .tooltip("")
                    .build()
                    .span();
                if (formatDetailJson.containsKey(key)) {
                    JSONObject keyJson = formatDetailJson.getJSONObject(key);
                    columnDef.render = keyJson;
                    if (keyJson.containsKey("headerName")) {
                        columnDef.headerName = keyJson.getString("headerName");
                    }
                    if (keyJson.containsKey("_tooltip")) {
                        columnDef.tooltip = keyJson.getString("_tooltip");
                    }
                    if (keyJson.containsKey("_filter")) {
                        columnDef.filter = keyJson.get("_filter");
                    }
                    if (keyJson.containsKey("_hide")) {
                        columnDef.hide = keyJson.getBooleanValue("_hide");
                    }
                }
                columnDefs.add(columnDef);
            }
        }
        return this;
    }

    @Override
    public Map<String, Object> toMap() {
        return ImmutableMap.of(
            "component", "CommonTableComponent",
            "props", ImmutableMap.of(
                "rowData", rowData,
                "columnDefs", columnDefs.stream().map(CommonTableColumnDef::toMap).collect(Collectors.toList())
            )
        );
    }

}
