package com.alibaba.tesla.dag.api;

import java.util.List;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.model.domain.TcDagInstNode;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;

/**
 * @author jinghua.yjh
 */
public interface DagInstApiService {

    /**
     * 启动dag场景
     */
    Long start(DagStartReq req) throws Exception;

    /**
     * 停止dag实例
     */
    void stop(Long dagInstId) throws Exception;

    /**
     * 重跑停止和错误节点
     */
    void rerunStoppedExceptionDagInst(Long dagInstId) throws Exception;

    /**
     * 重跑停止节点
     */
    void rerunStoppedDagInst(Long dagInstId) throws Exception;

    /**
     * 重跑错误节点
     */
    void rerunExceptionDagInst(Long dagInstId) throws Exception;

    /**
     * 新增场景实例的全局参数，putAll
     */
    void updateGlobalVariable(Long dagInstId, JSONObject globalVariable) throws Exception;

    /**
     * dag实例详情
     */
    TcDagInst detail(Long dagInstId) throws Exception;

    /**
     * dag实例节点详情
     */
    public List<TcDagInstNode> nodes(Long dagInstId) throws Exception;

    /**
     * 获取dag实例的全局参数
     */
    JSONObject globalVariable(Long dagInstId) throws Exception;

    /**
     * 获取场景实例的最上层父亲实例; 如果没有父，则返回自己
     */
    TcDagInst getDagInstTopFatherDagInst(Long dagInstId) throws Exception;

    /**
     * 获取场景及其自场景的所有执行节点
     */
    List<DagInstNodeWithChildren> dagInstNodeNest(Long dagInstId);

    /**
     * 获取指定状态的场景实例
     */
    List<TcDagInst> listDagInst(DagInstStatus status);
}
