package com.alibaba.tesla.dag.api;

import java.util.List;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.model.domain.TcDagInstNode;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.services.DagInstService;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author jinghua.yjh
 */
@Service
public class DagInstNodeApiServiceImpl implements DagInstNodeApiService {

    @Autowired
    TcDagInstNodeRepository dagInstNodeRepository;

    @Override
    public List<TcDagInstNode> listDagInstNode(DagInstNodeStatus status) {

        return dagInstNodeRepository.findAllByStatus(status.name());

    }

}
