package com.alibaba.tesla.dag.common;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @author jialiang.tjl
 */
@Slf4j
@Service
public class BeanUtil implements ApplicationContextAware {

    private static ApplicationContext context;

    public static <T> T getBean(Class<T> beanClass) {
        try {
            return context.getBean(beanClass);
        } catch (Exception e) {
            return (T) context.getBean(Tools.toLowerCaseFirstOne(beanClass.getSimpleName()));
        }
    }

    public static <T> Map<String, T> getSubBean(Class<T> beanClass) {
        return context.getBeansOfType(beanClass);
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        context = applicationContext;
    }
}
