package com.alibaba.tesla.dag.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

import static java.lang.String.format;

/**
 * @author yangjinghua
 */

public class RunCmd {

    public String cmd;
    public int timeout;

    public RunCmd(String cmd, int timeout) {
        this.cmd = cmd;
        this.timeout = timeout;
    }

    private long startTime;
    private Process process;
    private BufferedReader stdoutBufferedReader;
    private BufferedReader stderrBufferedReader;

    private int status;
    private StringBuilder stdoutSb = new StringBuilder();
    private StringBuilder stderrSb = new StringBuilder();

    private long endTime;

    public void start() throws IOException {

        startTime = System.currentTimeMillis() / 1000;
        process = Runtime.getRuntime().exec(cmd);
        stdoutBufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        stderrBufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));

    }

    public void waitFor() throws IOException, InterruptedException {
        while (process.isAlive()) {
            if (timeout > 0 && System.currentTimeMillis() / 1000 - startTime > timeout) {
                stderrSb.append(format("\n--- run cmd timeout; startTime: %s; timeout: %s; now: %s ---\n",
                    startTime, timeout, System.currentTimeMillis() / 1000));
                process.destroy();
            }
            flushOutErr();
            Thread.sleep(100);
        }
        flushOutErr();
        status = process.exitValue();
        endTime = System.currentTimeMillis() / 1000;
    }

    public void flushOutErr() throws IOException {
        while (stdoutBufferedReader.ready()) {
            stdoutSb.append(stdoutBufferedReader.readLine());
        }
        while (stderrBufferedReader.ready()) {
            stderrSb.append(stderrBufferedReader.readLine());
        }
    }

    public CmdOutPut runSync() throws IOException, InterruptedException {
        start();
        waitFor();
        return CmdOutPut.builder()
            .status(status)
            .stdout(stdoutSb.toString())
            .stderr(stderrSb.toString())
            .startTime(startTime)
            .endTime(endTime)
            .timeout(timeout)
            .cmd(cmd)
            .build();
    }
}

