package com.alibaba.tesla.dag.common;

import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import lombok.extern.slf4j.Slf4j;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

/**
 * @author jinghua.yjh
 */
@Slf4j
public class Tools {

    public static <T> T execExpression(String key, Map<String, Object> params, String expression, Class<T> tClass)
        throws Exception {
        try {
            log.info(">>>Tools|execExpression|enter|key={}, expression={}", key, expression);
            ExpressionParser parser = new SpelExpressionParser();
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setVariables(params);
            T result = parser.parseExpression(expression).getValue(context, tClass);
            log.info(">>>Tools|execExpression|exit|key={}, result={}", key, result);
            return result;
        } catch (Exception e) {
            throw new Exception("params: " + JSONObject.toJSONString(params)
                + "\nexpression: " + expression
                + "\nclass: " + tClass.getTypeName(), e);
        }
    }

    public static List<String> findAllMatch(String source, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(source);
        List<String> list = new ArrayList<>();
        while (matcher.find()) {
            list.add(matcher.group());
        }
        return list;
    }

    public static boolean onlyHave(List<String> statusList, List<String> subStatusList) {
        for (String s : statusList) {
            if (!subStatusList.contains(s)) {
                return false;
            }
        }
        return true;
    }

    public static String timeStamp2Date(Long seconds, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(seconds * 1000));
    }

    public static String timeStamp2Date(Integer seconds, String format) {
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(new Date(seconds * 1000L));
    }

    public static String timeStamp2Date(Integer seconds) {
        return timeStamp2Date(seconds, "yyyy-MM-dd HH:mm:ss");
    }

    public static String timeStamp2Date(Long seconds) {
        return timeStamp2Date(seconds, "yyyy-MM-dd HH:mm:ss");
    }

    public static String localIp = getLocalIp();

    public static String getLocalIp() {
        String ip;
        try {
            InetAddress addr = InetAddress.getLocalHost();
            ip = addr.getHostAddress();
        } catch (Exception ex) {
            ip = "";
        }
        return ip;
    }

    public static ThreadPoolExecutor createThreadPool(int maxPoolSize, String threadPoolName) {
        BlockingQueue<Runnable> blockingQueue = new LinkedBlockingQueue<>();
        return createThreadPoolWithQueue(maxPoolSize, threadPoolName, blockingQueue);
    }

    public static ThreadPoolExecutor createThreadPoolWithQueue(int maxPoolSize, String threadPoolName,
        BlockingQueue<Runnable> blockingQueue) {
        ThreadFactory threadFactory = new ThreadFactoryBuilder()
            .setNameFormat(String.format("%s-%s", threadPoolName, maxPoolSize) + "-%d").build();
        return new ThreadPoolExecutor(maxPoolSize, maxPoolSize, 0L, TimeUnit.MILLISECONDS, blockingQueue,
            threadFactory, new ThreadPoolExecutor.AbortPolicy());
    }

    public static String jsonObjectGetString(JSONObject jsonObject, String key) {
        Object value = JSONObject.toJSON(jsonObject.get(key));
        if (value instanceof JSON) {
            return JSONObject.toJSONString(value);
        }
        return jsonObject.getString(key);
    }

    public static List<String> classNameList(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> jarEntryEnumeration = jarFile.entries();
        List<String> classNameList = new ArrayList<>();
        while (jarEntryEnumeration.hasMoreElements()) {
            JarEntry jarEntry = jarEntryEnumeration.nextElement();
            if (!jarEntry.isDirectory()) {
                String name = jarEntry.getName();
                if (name.endsWith(".class") && !name.contains("$")) {
                    name = name.replace(".class", "").replace("/", ".");
                    classNameList.add(name);
                }
            }
        }
        return classNameList;
    }

    public static JSONObject userInfo(String empid) throws Exception {
        JSONObject userInfo = Requests.get("http://connector.mw.tesla.alibaba-inc.com/buc/user/" + empid,
            JSONObject.class);
        return userInfo.getJSONObject("data");
    }

    public static void randomSleep(int bound) {
        try {
            Thread.sleep(new Random().nextInt(bound));
        } catch (InterruptedException e) {
            log.error("", e);
        }
    }

    // 随机睡眠一段时间
    public static void randomSleep() {
        randomSleep(1000);
    }

    public static String toLowerCaseFirstOne(String s) {
        if (Character.isLowerCase(s.charAt(0))) {
            return s;
        } else {
            return Character.toLowerCase(s.charAt(0)) + s.substring(1);
        }
    }

    public static void main(String[] args) throws Exception {
        Map<String, Object> params = ImmutableMap.of(
            "check_dam_status_a5e8560d47c341afb45a6dd297db2805", ImmutableMap.of(
                "result", ImmutableMap.of(
                    "status", "CRITICAL"
                )
            )
        );
        String expression = "#check_dam_status_a5e8560d47c341afb45a6dd297db2805['result']['status'] != 'OK'";
        execExpression("", params, expression, Boolean.class);

        Boolean result = execExpression("", new HashMap<>(), "1==1", Boolean.class);
        System.out.println(result);
    }

}
