package com.alibaba.tesla.dag.config;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@Slf4j
public class DagAsyncConfig {
    @Value("${dag.scheduling.maxPoolSize:50}")
    public int dagSchedulingMaxPoolSize;

    @Value("${dag.monitor.maxPoolSize:100}")
    public int dagMonitorMaxPoolSize;

    @Bean("instAsyncTaskExecutor")
    public ThreadPoolTaskExecutor instAsyncTaskExecutor() {
        ThreadPoolTaskExecutor instAsyncTaskExecutor = new ThreadPoolTaskExecutor();
        instAsyncTaskExecutor.setMaxPoolSize(dagSchedulingMaxPoolSize);
        instAsyncTaskExecutor.setCorePoolSize(dagSchedulingMaxPoolSize);
        instAsyncTaskExecutor.setThreadNamePrefix("dag-scheduling-thread-pool-");
        instAsyncTaskExecutor.initialize();
        return instAsyncTaskExecutor;
    }

    @Bean("nodeAsyncTaskExecutor")
    public ThreadPoolTaskExecutor nodeAsyncTaskExecutor() {
        ThreadPoolTaskExecutor nodeAsyncTaskExecutor = new ThreadPoolTaskExecutor();
        nodeAsyncTaskExecutor.setMaxPoolSize(dagMonitorMaxPoolSize);
        nodeAsyncTaskExecutor.setCorePoolSize(dagMonitorMaxPoolSize);
        nodeAsyncTaskExecutor.setThreadNamePrefix("dag-monitor-thread-pool-");
        nodeAsyncTaskExecutor.initialize();
        return nodeAsyncTaskExecutor;
    }
}
