package com.alibaba.tesla.dag.dispatch;

import com.alibaba.tesla.dag.notify.DagInstDispatch;
import com.alibaba.tesla.dag.notify.IDagInstNotify;
import com.alibaba.tesla.dag.repository.dao.DagInstDAO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.schedule.evaluation.EvaluationService;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.services.DagInstNewService;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * @author QianMo
 * @date 2021/04/22.
 */
@Service
@Slf4j
public class InitDagInstDispatcher implements IDagInstDispatcher {

    @Autowired
    private DagInstDAO dagInstDAO;

    @Autowired
    private IDagInstNotify dagInstNotify;

    @Autowired
    private DagInstNewService dagInstNewService;

    @Autowired
    private EvaluationService evaluationService;

    @Override
    public DagInstStatus registerType() {
        return DagInstStatus.INIT;
    }

    @Override
    public void dispatch(DagInstDO dagInstDO) {
        Long dagInstId = dagInstDO.getId();
        log.info(">>>[Init]|dispatch|dagInstId={}", dagInstId);

        if (StringUtils.isEmpty(dagInstDO.getEvaluationCreateRet())) {
            DagInstDO update = DagInstDO.builder().id(dagInstId).build();
            update.setEvaluationCreateRet(evaluationService.create(dagInstDO));

            dagInstDAO.update(update);
        }

        DagInstDispatch dagInstDispatch = dagInstNewService.initInst(dagInstDO, registerType());

        dagInstNotify.sendDagInstDispatch(dagInstDispatch);
    }
}
