package com.alibaba.tesla.dag.dispatch;

import java.util.Objects;

import com.alibaba.tesla.dag.constant.DagConstant;
import com.alibaba.tesla.dag.notify.DagInstNodeTask;
import com.alibaba.tesla.dag.notify.IDagInstNodeTaskNotify;
import com.alibaba.tesla.dag.notify.NodeTaskType;
import com.alibaba.tesla.dag.repository.dao.DagInstNodeDAO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.services.DagInstNewService;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static java.lang.String.format;

/**
 * @author QianMo
 * @date 2021/04/22.
 */
@Service
@Slf4j
public class PostRunningDagInstDispatcher implements IDagInstDispatcher {

    @Autowired
    private DagInstNodeDAO dagInstNodeDAO;

    @Autowired
    private IDagInstNodeTaskNotify dagInstNodeTaskNotify;

    @Autowired
    private DagInstNewService dagInstNewService;

    @Override
    public DagInstStatus registerType() {
        return DagInstStatus.POST_RUNNING;
    }

    @Override
    public void dispatch(DagInstDO dagInstDO) {
        Long dagInstId = dagInstDO.getId();
        log.info(">>>postRunningDagInstDispatcher|dispatch|dagInstId={}", dagInstId);

        DagInstNodeDO postNode = dagInstNodeDAO.getDagInstNode(dagInstId, DagConstant.POST_NODE_ID);
        if (Objects.isNull(postNode)) {
            log.warn(">>>postRunningDagInstDispatcher|dispatch|postNode is not exist|dagInstId={}", dagInstId);
            return;
        }

        DagInstNodeStatus status = postNode.fetchNodeStatus();
        switch (status) {
            case STOPPED:
            case SKIP:
            case SKIP_CAUSE_BY_STOPPED:
            case SKIP_CAUSE_BY_EXCEPTION:
            case EXCEPTION:
                dagInstNewService.freshInstStatusWithDetail(dagInstDO, registerType(), DagInstStatus.EXCEPTION,
                    format("run post node exception -- status: %s; detail: %s", status,
                        postNode.getStatusDetail()));
                break;
            case INIT:
            case STOPPING:
            case RUNNING:
            case WAIT_STOP:
                DagInstNodeTask dagInstNodeTask = DagInstNodeTask.builder().dagInstId(
                    dagInstId).nodeId(postNode.getNodeId()).nodeTaskType(NodeTaskType.START).build();
                dagInstNodeTaskNotify.sendDagInstNodeTask(dagInstNodeTask);
                break;
            case SUCCESS:
                dagInstNewService.freshInstStatus(dagInstDO, registerType(), DagInstStatus.SUCCESS);
                break;
            default:
                break;
        }
    }
}
