package com.alibaba.tesla.dag.dispatch;

import com.alibaba.tesla.dag.constant.DagConstant;
import com.alibaba.tesla.dag.notify.*;
import com.alibaba.tesla.dag.repository.dao.DagInstNodeDAO;
import com.alibaba.tesla.dag.repository.domain.DagInstDO;
import com.alibaba.tesla.dag.repository.domain.DagInstNodeDO;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.services.DagInstNewService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Objects;

import static java.lang.String.format;

/**
 * @author QianMo
 * @date 2021/04/22.
 */
@Service
@Slf4j
public class PreRunningDagInstDispatcher implements IDagInstDispatcher {
    @Autowired
    private DagInstNodeDAO dagInstNodeDAO;

    @Autowired
    private IDagInstNotify dagInstNotify;

    @Autowired
    private IDagInstNodeTaskNotify dagInstNodeTaskNotify;

    @Autowired
    private DagInstNewService dagInstNewService;

    @Override
    public DagInstStatus registerType() {
        return DagInstStatus.PRE_RUNNING;
    }

    @Override
    public void dispatch(DagInstDO dagInstDO) {
        Long dagInstId = dagInstDO.getId();

        log.info(">>>[PreRunning]|dispatch|dagInstId={}", dagInstId);

        DagInstNodeDO preNode = dagInstNodeDAO.getDagInstNode(dagInstId, DagConstant.PRE_NODE_ID);
        if (Objects.isNull(preNode)) {
            log.warn(">>>preRunningDagInstDispatcher|dispatch|preNode is not exist|dagInstId={}", dagInstId);
            return;
        }

        DagInstNodeStatus status = preNode.fetchNodeStatus();


        switch (status) {
            case EXCEPTION:
            case SKIP_CAUSE_BY_EXCEPTION:
            case WAIT_STOP:
            case SKIP_CAUSE_BY_STOPPED:
                dagInstNewService.freshInstStatusWithDetail(dagInstDO, registerType(), DagInstStatus.EXCEPTION,
                        format("run pre node exception -- status: %s; detail: %s",
                                status, preNode.getStatusDetail()));
                break;
            case RUNNING:
            case STOPPING:
            case INIT:
                DagInstNodeTask dagInstNodeTask = DagInstNodeTask.builder().dagInstId(
                        dagInstId).nodeId(preNode.getNodeId()).nodeTaskType(NodeTaskType.START).build();
                dagInstNodeTaskNotify.sendDagInstNodeTask(dagInstNodeTask);
                break;
            case SUCCESS:
            case SKIP:
            case STOPPED:
                dagInstNewService.freshInstStatus(dagInstDO, registerType(), DagInstStatus.RUNNING);

                DagInstDispatch dagInstDispatch = DagInstDispatch.builder().dagInstId(dagInstId).nodeId(preNode.getNodeId()).dagInstStatus(
                        DagInstStatus.RUNNING).build();
                dagInstNotify.sendDagInstDispatch(dagInstDispatch);
                break;
            default:
                break;
        }
    }
}
