package com.alibaba.tesla.dag.local;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.domain.TcDag;
import com.alibaba.tesla.dag.model.domain.TcDagNode;
import com.alibaba.tesla.dag.model.domain.dag.DagInputParam;
import com.alibaba.tesla.dag.model.domain.dagnode.DagInstNodeType;
import com.alibaba.tesla.dag.model.repository.TcDagNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMap.Builder;
import lombok.extern.slf4j.Slf4j;

import static java.lang.String.format;

/**
 * @author jinghua.yjh
 */
@Slf4j
public abstract class AbstractLocalDagBase extends AbstractLocalBase {

    // 创建人
    public static String creator = DEFAULT_CREATOR;

    // 所属产品
    public static String appId = DEFAULT_APP_ID;

    // 不指定使用继承类的类名
    public static String name = null;

    // 不指定使用name
    public static String alias = null;

    public static Integer hasFeedback = 0;

    public static Integer hasHistory = 1;

    // 不指定为空
    public static String description = "";

    // 场景输入指标
    public static List<DagInputParam> inputParams = new ArrayList<>();

    // nodes
    public Map<String, Map<String, Object>> nodeMap = new HashMap<>(0);

    // edges
    public Map<String, Map<String, Object>> edgeMap = new HashMap<>(0);

    public void node(String name) throws Exception {
        node(appId, name, name, false, -1);
    }

    public void node(String name, Integer index) throws Exception {
        node(appId, name, name, false, index);
    }

    public void node(String name, String nodeId) throws Exception {
        node(appId, name, nodeId, false, -1);
    }

    public void node(String name, Boolean isDag) throws Exception {
        node(appId, name, name, isDag, -1);
    }

    public void node(String appId, String name, String nodeId) throws Exception {
        node(appId, name, nodeId, false, -1);
    }

    public void node(String appId, String name, String nodeId, Boolean isDag, Integer index) throws Exception {
        node(
            DagAddNodeReq.builder()
                .appId(appId)
                .name(name)
                .nodeId(nodeId)
                .isDag(isDag)
                .index(index)
                .build()
        );
    }

    public void node(DagAddNodeReq req) throws Exception {

        if (nodeMap.containsKey(req.nodeId)) {
            throw new Exception("nodeId must be unique in dag");
        }
        long defId;
        if (req.isDag) {
            TcDag dag = BeanUtil.getBean(TcDagRepository.class).findFirstByAppIdAndName(req.appId, req.name);
            if (dag == null) {
                log.warn(format("dag with appId: %s name: %s not exists", req.appId, req.name));
                defId = -1;
                //throw new Exception();
            } else {
                defId = dag.getId();
            }
        } else {
            TcDagNode dagNode = BeanUtil.getBean(TcDagNodeRepository.class)
                .findFirstByAppIdAndName(req.appId, req.name);
            if (dagNode == null) {
                throw new Exception(format("dagNode with appId: %s name: %s not exists", req.appId, req.name));
            }
            defId = dagNode.getId();
        }
        Builder<String, Object> dataBuilder = new Builder<String, Object>()
            .put("type", req.isDag ? DagInstNodeType.DAG.name() : DagInstNodeType.NODE.name())
            .put("id", req.nodeId)
            .put("label", req.name)
            .put("inputParams", new ArrayList<>())
            .put("defId", defId);
        if (req.retryExpression != null) {
            dataBuilder.put("retryExpression", req.retryExpression);
        }
        if (req.maxRetryTimes != null) {
            dataBuilder.put("maxRetryTimes", req.maxRetryTimes);
        }

        nodeMap.put(req.nodeId, ImmutableMap.of(
            "index", req.index,
            "id", req.nodeId,
            "label", req.name,
            "shape", "rect",
            "data", dataBuilder.build())
        );
    }

    public void edge(String nodeId1, String nodeId2) throws Exception {
        edge(nodeId1, nodeId2, "");
    }

    public void edge(String nodeId1, String nodeId2, String expression) throws Exception {
        String name = JSONObject.toJSONString(ImmutableList.of(nodeId1, nodeId2));
        if (edgeMap.containsKey(name)) {
            throw new Exception("edge must be unique within two nodes");
        }
        edgeMap.put(name, ImmutableMap.of(
            "source", nodeId1,
            "target", nodeId2,
            "shape", "QuadraticEdge",
            "data", ImmutableMap.of(
                "expression", expression
            ),
            "style", ImmutableMap.of(
                "endArrow", true,
                "stroke", "#fdad",
                "lineWidth", 2
            )
        ));
    }

    public abstract void draw() throws Exception;

}
