package com.alibaba.tesla.dag.local;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.domain.TcDagInst;
import com.alibaba.tesla.dag.model.domain.dagnode.*;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.util.ArrayList;
import java.util.List;

/**
 * @author jinghua.yjh
 */
@NoArgsConstructor
@Data
public abstract class AbstractLocalNodeBase extends AbstractLocalBase {

    // 创建人
    public static String creator = DEFAULT_CREATOR;

    // 所属产品
    public static String appId = DEFAULT_APP_ID;

    // 执行超时时间
    public static Integer runTimeout = 300;

    // 执行重试上限，值为1的时候，节点最多执行两次
    public static long maxRetryTimes = 0;

    // 执行重试判断
    public static String retryExpression = "";

    // 不指定使用继承类的类名
    public static String name = null;

    // 不指定使用name
    public static String alias = null;

    // 不指定为空
    public static String description = "";

    // 不指定为0，表示其他产品在页面上看不到
    public static int isShare = 0;

    // 不指定为1，表示会在报表中展示
    public static int isShow = 1;

    // 不指定为空，页面上显示没有输入参数
    public static List<DagNodeInputParam> inputParams = new ArrayList<>();

    // 不指定为空，页面上显示没有输出参数
    public static List<DagNodeOutputParam> outputParams = new ArrayList<>();

    // 报表中展示该node的类型
    public static DagNodeFormatType formatType = DagNodeFormatType.CUSTOM;

    // 展示详情
    public static String formatDetail = "";

    // 节点类型 FAAS/TASK
    public static DagNodeType nodeType = DagNodeType.LOCAL;

    // 输入的执行参数，根据inputParams转换过来的
    public JSONObject params;

    // 全局参数
    public JSONObject globalParams;

    // 清空全局参数
    public Boolean isDeleteParams = false;

    // 最新获取全局变量的时间
    public Long lastGlobalVariableTimestamp;

    // 全局变量
    public JSONObject globalVariable;

    // 上游节点执行的结果，包括result、output
    public JSONObject globalResult;

    // 执行的场景的实例Id
    public Long dagInstId;

    // 执行的节点的实例Id
    public Long dagInstNodeId;

    // 执行的真实nodeId
    public String nodeId;

    // dagInst在所属的dagInst中的nodeId，如果有的话
    public String fatherNodeId;

    // 重试次数，首次执行的重试次数是0
    public long retryTimes = 0;

    // 实例创建时间
    public long instanceCreateTimestamp = 0;

    // run开始执行时间
    public long actRunTimestamp = 0;

    // stop开始执行时间
    public long actStopTimestamp = 0;

    // 实例真实执行超时时间
    public long realRunTimeout = 0;

    // 节点执行逻辑
    public abstract DagInstNodeRunRet run() throws Exception;

    public void freshGlobalVariable() {
        if (System.currentTimeMillis() / 1000 - lastGlobalVariableTimestamp < 1) {
            return;
        }
        TcDagInst dagInst = BeanUtil.getBean(TcDagInstRepository.class).findFirstById(dagInstId);

        globalVariable = dagInst.globalVariableJson();
        lastGlobalVariableTimestamp = System.currentTimeMillis() / 1000;
    }

    public void stop() {
    }

}
