package com.alibaba.tesla.dag.local;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Builder.Default;
import lombok.NoArgsConstructor;
import org.apache.commons.lang3.StringUtils;

@NoArgsConstructor
@AllArgsConstructor
@Builder
public class DagAddNodeReq {

    @Default
    String appId = AbstractLocalBase.DEFAULT_APP_ID;

    String name;

    String nodeId;

    @Default
    Boolean isDag = false;

    @Default
    Integer index = -1;

    Long maxRetryTimes;

    String retryExpression;

    Class<AbstractLocalBase> aClass;

    public String getAppId() {
        return StringUtils.isEmpty(appId) ? AbstractLocalBase.DEFAULT_APP_ID : appId;
    }

    public String getName() throws Exception {
        if (StringUtils.isEmpty(name)) {
            String name = (String)aClass.getField("name").get(aClass);
            if (StringUtils.isEmpty(name)) {
                name = aClass.getSimpleName();
            }
            this.name = name;
        }
        return name;
    }

    public String getNodeId() throws Exception {
        return StringUtils.isEmpty(nodeId) ? getName() : nodeId;
    }

    public Boolean isDag() {
        return isDag == null ? false : isDag;
    }

    public Integer getIndex() {
        return index == null || index < 0 ? -1 : index;
    }

}
