package com.alibaba.tesla.dag.model.domain;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @author jinghua.yjh
 */
@Slf4j
@Data
public abstract class AbstractTcDag {

    public Long id;

    public Long gmtCreate;

    public Long gmtModified;

    public abstract void save();

    public abstract void flush();

    public void saveWithTime() {
        if (getGmtCreate() == null) {
            setGmtCreate(System.currentTimeMillis() / 1000);
        }
        setGmtModified(System.currentTimeMillis() / 1000);
        save();
    }

}