package com.alibaba.tesla.dag.model.domain;

import javax.persistence.*;

import com.alibaba.fastjson.util.TypeUtils;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.repository.TcDagConfigRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

/**
 * @author jinghua.yjh
 */
@EqualsAndHashCode(callSuper = true)
@Slf4j
@Table
@Entity
@EntityListeners(AuditingEntityListener.class)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TcDagConfig extends AbstractTcDag {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column
    private Long gmtCreate;

    @Column
    private Long gmtModified;

    @Column
    private String name;

    @Column
    private String content;

    public Integer getInteger(Integer defaultContent) {
        Integer ret = TypeUtils.castToInt(content);
        return ret == null ? defaultContent : ret;
    }

    public Long getLong(Long defaultContent) {
        Long ret = TypeUtils.castToLong(content);
        return ret == null ? defaultContent : ret;
    }

    public static Long getLong(String name) {
        TcDagConfigRepository configRepository = BeanUtil.getBean(TcDagConfigRepository.class);
        TcDagConfig dagConfig = configRepository.findFirstByName(name);
        if (dagConfig == null) {
            return null;
        }
        if (StringUtils.isEmpty(dagConfig.content)) {
            return null;
        }
        return TypeUtils.castToLong(dagConfig.content);
    }

    public static Long getLong(String name, Long d) {
        TcDagConfigRepository configRepository = BeanUtil.getBean(TcDagConfigRepository.class);
        TcDagConfig dagConfig = configRepository.findFirstByName(name);
        if (dagConfig == null) {
            return d;
        } else {
            return dagConfig.getLong(d);
        }
    }

    public static Integer getInteger(String name, Integer d) {
        TcDagConfigRepository configRepository = BeanUtil.getBean(TcDagConfigRepository.class);
        TcDagConfig dagConfig = configRepository.findFirstByName(name);
        if (dagConfig == null) {
            return d;
        } else {
            return dagConfig.getInteger(d);
        }
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagConfigRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagConfigRepository.class).flush();
    }

}
