package com.alibaba.tesla.dag.model.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import com.alibaba.tesla.dag.schedule.status.DagInstNodeStatus;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import lombok.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @author jinghua.yjh
 */
@Slf4j
@EqualsAndHashCode(callSuper = true)
@Table
@Entity
@EntityListeners(AuditingEntityListener.class)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TcDagInst extends AbstractTcDag {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column
    private Long gmtCreate;

    @Column
    private Long gmtModified;

    @Column
    private Long gmtAccess;

    @Column
    private String appId;

    @Column
    private Long dagId;

    @Column(columnDefinition = "longtext")
    private String tcDagDetail;

    @Column
    private String status;

    @Column(columnDefinition = "longtext")
    private String statusDetail;

    @Column(columnDefinition = "longtext")
    private String globalParams;

    @Column(columnDefinition = "longtext")
    private String globalObject;

    @Column(columnDefinition = "longtext")
    private String globalVariable;

    @Column(columnDefinition = "longtext")
    private String globalResult;

    @Column
    private String lockId;

    @Column
    private String creator;

    @Column
    private Integer isSub;

    @Column
    private String tag;

    @Column
    private String standaloneIp;

    @Column(columnDefinition = "longtext")
    private String evaluationCreateRet;

    @Column
    private String channel;

    @Column
    private String env;

    @Transient
    private TcDag dag;

    public void setNodeId(String nodeId) {
        JSONObject globalVariableJson = globalVariableJson();
        globalVariableJson.put("__NODE__ID__", nodeId);
        globalVariable = JSONObject.toJSONString(globalVariableJson);
    }

    public String nodeId() {
        return globalVariableJson().getString("__NODE__ID__");
    }

    public TcDag dag() {
        if (dag == null) {
            dag = JSONObject.parseObject(tcDagDetail, TcDag.class);
        }
        return dag;
    }

    public String channel() {
        if (StringUtils.isEmpty(channel)) {
            return "NotDefined";
        }
        return channel;
    }

    public DagInstStatus status() {
        return DagInstStatus.valueOf(status);
    }

    public boolean isSub() {
        return isSub == 1;
    }

    public JSONObject globalVariableJson() {
        return StringUtils.isEmpty(globalVariable) ? new JSONObject() : JSONObject.parseObject(globalVariable);
    }

    public JSONObject globalParamsJson() {
        return StringUtils.isEmpty(globalParams) ? new JSONObject() : JSONObject.parseObject(globalParams);
    }

    public JSONObject globalResultJson() {
        return StringUtils.isEmpty(globalResult) ? new JSONObject() : JSONObject.parseObject(globalResult);
    }

    public void saveAndFlush() {
        BeanUtil.getBean(TcDagInstRepository.class).saveAndFlush(this);
    }

    public List<TcDagInstNode> nodes(DagInstNodeStatus... statusList) {
        return BeanUtil.getBean(TcDagInstNodeRepository.class).findAllByDagInstIdAndNodeIdNotInAndStatusIn(
                id,
                Arrays.asList("__pre_node__", "__post_node__"),
                Arrays.stream(statusList).map(Enum::toString).collect(Collectors.toList())
        );
    }

    public List<TcDagInstNode> nodes() {
        return BeanUtil.getBean(TcDagInstNodeRepository.class).findAllByDagInstIdAndNodeIdNotIn(id,
                Arrays.asList("__pre_node__", "__post_node__"));
    }

    public TcDagInstNode postNode() {
        return BeanUtil.getBean(TcDagInstNodeRepository.class).findFirstByDagInstIdAndNodeId(id, "__post_node__");
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagInstRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagInstRepository.class).flush();
    }
}
