package com.alibaba.tesla.dag.model.domain;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.repository.TcDagInstEdgeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeRepository;
import com.alibaba.tesla.dag.model.repository.TcDagInstRepository;
import com.alibaba.tesla.dag.schedule.status.DagInstEdgeStatus;
import lombok.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

import javax.persistence.*;

/**
 * @author jinghua.yjh
 */
@EqualsAndHashCode(callSuper = true)
@Slf4j
@Table
@Entity
@EntityListeners(AuditingEntityListener.class)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TcDagInstEdge extends AbstractTcDag {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    public Long id;

    @Column
    public Long gmtCreate;

    @Column
    public Long gmtModified;

    @Column
    public Long dagInstId;

    @Column
    public String source;

    @Column
    public String target;

    @Column
    public String label;

    @Column
    public String shape;

    @Column(columnDefinition = "longtext")
    public String style;

    @Column(columnDefinition = "longtext")
    public String data;

    @Column
    public Integer isPass;

    @Column(columnDefinition = "longtext")
    public String exception;

    @Column
    public String status;

    public DagInstEdgeStatus status() {
        status = StringUtils.isEmpty(status) ? "INIT" : status;
        return DagInstEdgeStatus.valueOf(status);
    }

    public String getException() {
        if (isPass == null) {
            return "";
        } else {
            if (StringUtils.isEmpty(exception)) {
                return "SUCCESS";
            } else {
                return "EXCEPTION";
            }
        }
    }

    public JSONObject dataJson() {
        return StringUtils.isEmpty(data) ? new JSONObject() : JSONObject.parseObject(data);
    }

    public String expression() {
        return dataJson().getString("expression");
    }

    public TcDagInst dagInst() {
        return BeanUtil.getBean(TcDagInstRepository.class).findFirstById(dagInstId);
    }

    public TcDagInstNode sourceNode() {
        return BeanUtil.getBean(TcDagInstNodeRepository.class).findFirstByDagInstIdAndNodeId(dagInstId, source);
    }

    public void saveAndFlush() {
        BeanUtil.getBean(TcDagInstEdgeRepository.class).saveAndFlush(this);
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagInstEdgeRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagInstEdgeRepository.class).flush();
    }
}
