package com.alibaba.tesla.dag.model.domain;

import javax.persistence.*;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.repository.TcDagInstNodeStdRepository;
import com.alibaba.tesla.dag.schedule.status.DagInstStatus;
import com.alibaba.tesla.dag.schedule.task.TaskStatus;

import com.google.common.base.Throwables;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

/**
 * @author jinghua.yjh
 */
@EqualsAndHashCode(callSuper = true)
@Slf4j
@Table
@Entity
@EntityListeners(AuditingEntityListener.class)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TcDagInstNodeStd extends AbstractTcDag {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column
    private Long gmtCreate;

    @Column
    private Long gmtModified;

    @Column
    private Long gmtAccess;

    @Column
    private String status;

    @Column(columnDefinition = "longtext")
    private String stdout;

    @Column(columnDefinition = "longtext")
    private String stderr;

    @Column(columnDefinition = "longtext")
    private String globalParams;

    @Column
    private String ip;

    @Column
    private String standaloneIp;

    @Column(columnDefinition = "longtext")
    private String comment;

    @Column
    private Integer isStop;

    @Column
    private Long stopId;

    @Column
    private String lockId;

    @Column
    private Long dagInstId;

    @Column
    private Long dagInstNodeId;

    public boolean isStop() {
        return isStop != null && 1 == isStop;
    }

    public Object globalParams() {
        if (!"__DEL__".equals(globalParams)) {
            return JSONObject.parseObject(globalParams);
        }
        return globalParams;
    }

    public TaskStatus status() {
        return TaskStatus.valueOf(status);
    }

    public TcDagInstNodeStd patchError(Exception e) {
        setGmtModified(System.currentTimeMillis() / 1000);
        this.status = TaskStatus.EXCEPTION.name();
        setStdout("");
        setStderr(Throwables.getStackTraceAsString(e));
        return this;
    }

    public JSONObject stdout() {
        return JSONObject.parseObject(stdout, Feature.OrderedField);
    }

    public void saveStatus(TaskStatus status) {
        setGmtModified(System.currentTimeMillis() / 1000);
        this.status = status.toString();
        saveAndFlush();
    }

    public void saveStatus(Exception e) {
        setGmtModified(System.currentTimeMillis() / 1000);
        this.status = TaskStatus.EXCEPTION.toString();
        this.stderr = Throwables.getStackTraceAsString(e);
        saveAndFlush();
    }

    public void saveAndFlush() {
        if (gmtCreate == null) {
            gmtCreate = System.currentTimeMillis() / 1000;
        }
        gmtModified = System.currentTimeMillis() / 1000;
        BeanUtil.getBean(TcDagInstNodeStdRepository.class).saveAndFlush(this);
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagInstNodeStdRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagInstNodeStdRepository.class).flush();
    }

    public void statusSet(Exception e) {
        this.status = DagInstStatus.EXCEPTION.toString();
        this.stderr = Throwables.getStackTraceAsString(e);
    }

    public void statusSet(TaskStatus status) {
        this.status = status.toString();
    }

}
