package com.alibaba.tesla.dag.model.domain;

import javax.persistence.*;

import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.repository.TcDagConfigRepository;
import com.alibaba.tesla.dag.model.repository.TcDagOptionsRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

/**
 * @author jinghua.yjh
 */
@EqualsAndHashCode(callSuper = true)
@Table(uniqueConstraints = {@UniqueConstraint(columnNames = {"locale", "name"})})
@Entity
@EntityListeners(AuditingEntityListener.class)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TcDagOptions extends AbstractTcDag {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column
    private String locale;

    @Column(length = 256)
    private String name;

    @Column(columnDefinition = "longtext")
    private String value;

    public static String value(String locale, String name) {
        TcDagOptions dagOptions = BeanUtil.getBean(TcDagOptionsRepository.class).findFirstByLocaleAndName(locale, name);
        if (dagOptions == null) {
            return null;
        } else {
            return dagOptions.getValue();
        }
    }

    public void upsert() {
        TcDagOptionsRepository dagOptionsRepository = BeanUtil.getBean(TcDagOptionsRepository.class);
        TcDagOptions dagOptions = dagOptionsRepository.findFirstByLocaleAndName(locale, name);
        id = dagOptions == null ? null : dagOptions.getId();
        dagOptionsRepository.saveAndFlush(this);
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagOptionsRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagOptionsRepository.class).flush();
    }

}
