package com.alibaba.tesla.dag.model.domain;

import javax.persistence.*;

import com.alibaba.tesla.dag.common.BeanUtil;
import com.alibaba.tesla.dag.model.repository.TcDagConfigRepository;
import com.alibaba.tesla.dag.model.repository.TcDagRepository;
import com.alibaba.tesla.dag.model.repository.TcDagServiceNodeRepository;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.jpa.domain.support.AuditingEntityListener;

/**
 * @author jinghua.yjh
 */
@EqualsAndHashCode(callSuper = true)
@Slf4j
@Table(uniqueConstraints = {@UniqueConstraint(columnNames = {"ip"})})
@Entity
@EntityListeners(AuditingEntityListener.class)
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class TcDagServiceNode extends AbstractTcDag {

    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    private Long id;

    @Column
    private Long gmtCreate;

    @Column
    private Long gmtModified;

    @Column
    private String ip;

    @Column
    private Integer enable;

    public boolean enable() {
        return enable == 1;
    }

    @Override
    public void save() {
        BeanUtil.getBean(TcDagServiceNodeRepository.class).save(this);
    }

    @Override
    public void flush() {
        BeanUtil.getBean(TcDagServiceNodeRepository.class).flush();
    }

}
